/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.master;

import io.crate.common.unit.TimeValue;
import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.TransportRequest;

public abstract class MasterNodeRequest<Request extends MasterNodeRequest<Request>>
extends TransportRequest {
    public static final TimeValue DEFAULT_MASTER_NODE_TIMEOUT = TimeValue.timeValueSeconds(30L);
    protected TimeValue masterNodeTimeout = DEFAULT_MASTER_NODE_TIMEOUT;

    protected MasterNodeRequest() {
    }

    protected MasterNodeRequest(StreamInput in) throws IOException {
        super(in);
        this.masterNodeTimeout = in.readTimeValue();
    }

    public final Request masterNodeTimeout(TimeValue timeout) {
        this.masterNodeTimeout = timeout;
        return (Request)this;
    }

    public final Request masterNodeTimeout(String timeout) {
        return this.masterNodeTimeout(TimeValue.parseTimeValue(timeout, null, this.getClass().getSimpleName() + ".masterNodeTimeout"));
    }

    public final TimeValue masterNodeTimeout() {
        return this.masterNodeTimeout;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeTimeValue(this.masterNodeTimeout);
    }
}

