/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.master;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.TransportResponse;

public class AcknowledgedResponse
extends TransportResponse {
    protected final boolean acknowledged;

    public AcknowledgedResponse(boolean acknowledged) {
        this.acknowledged = acknowledged;
    }

    public final boolean isAcknowledged() {
        return this.acknowledged;
    }

    public AcknowledgedResponse(StreamInput in) throws IOException {
        this.acknowledged = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.acknowledged);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AcknowledgedResponse that = (AcknowledgedResponse)o;
        return this.isAcknowledged() == that.isAcknowledged();
    }

    public int hashCode() {
        return Objects.hash(this.isAcknowledged());
    }
}

