/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskAwareRequest;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;

public abstract class TransportAction<Request extends TransportRequest, Response extends TransportResponse> {
    protected final String actionName;
    protected final TaskManager taskManager;

    protected TransportAction(String actionName, TaskManager taskManager) {
        this.actionName = actionName;
        this.taskManager = taskManager;
    }

    public final ActionFuture<Response> execute(Request request) {
        PlainActionFuture future = PlainActionFuture.newFuture();
        this.execute(request, future);
        return future;
    }

    public final Task execute(Request request, final ActionListener<Response> listener) {
        final Task task = this.taskManager.register("transport", this.actionName, (TaskAwareRequest)request);
        this.execute(task, request, new ActionListener<Response>(){

            @Override
            public void onResponse(Response response) {
                TransportAction.this.taskManager.unregister(task);
                listener.onResponse(response);
            }

            @Override
            public void onFailure(Exception e) {
                TransportAction.this.taskManager.unregister(task);
                listener.onFailure(e);
            }
        });
        return task;
    }

    public final void execute(Task task, Request request, ActionListener<Response> listener) {
        try {
            this.doExecute(task, request, listener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    protected abstract void doExecute(Task var1, Request var2, ActionListener<Response> var3);
}

