/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;

public class IndicesOptions
implements ToXContentFragment {
    public static final IndicesOptions STRICT_EXPAND_OPEN = new IndicesOptions(EnumSet.of(Option.ALLOW_NO_INDICES), EnumSet.of(WildcardStates.OPEN));
    public static final IndicesOptions LENIENT_EXPAND_OPEN = new IndicesOptions(EnumSet.of(Option.ALLOW_NO_INDICES, Option.IGNORE_UNAVAILABLE), EnumSet.of(WildcardStates.OPEN));
    public static final IndicesOptions LENIENT_EXPAND_OPEN_CLOSED = new IndicesOptions(EnumSet.of(Option.ALLOW_NO_INDICES, Option.IGNORE_UNAVAILABLE), EnumSet.of(WildcardStates.OPEN, WildcardStates.CLOSED));
    public static final IndicesOptions STRICT_EXPAND_OPEN_CLOSED = new IndicesOptions(EnumSet.of(Option.ALLOW_NO_INDICES), EnumSet.of(WildcardStates.OPEN, WildcardStates.CLOSED));
    public static final IndicesOptions STRICT_EXPAND_OPEN_FORBID_CLOSED = new IndicesOptions(EnumSet.of(Option.ALLOW_NO_INDICES, Option.FORBID_CLOSED_INDICES), EnumSet.of(WildcardStates.OPEN));
    public static final IndicesOptions STRICT_SINGLE_INDEX_NO_EXPAND_FORBID_CLOSED = new IndicesOptions(EnumSet.of(Option.FORBID_ALIASES_TO_MULTIPLE_INDICES, Option.FORBID_CLOSED_INDICES), EnumSet.noneOf(WildcardStates.class));
    private final EnumSet<Option> options;
    private final EnumSet<WildcardStates> expandWildcards;

    public IndicesOptions(EnumSet<Option> options, EnumSet<WildcardStates> expandWildcards) {
        this.options = options;
        this.expandWildcards = expandWildcards;
    }

    private IndicesOptions(Collection<Option> options, Collection<WildcardStates> expandWildcards) {
        this(options.isEmpty() ? Option.NONE : EnumSet.copyOf(options), expandWildcards.isEmpty() ? WildcardStates.NONE : EnumSet.copyOf(expandWildcards));
    }

    static IndicesOptions fromByte(byte id) {
        HashSet<Option> opts = new HashSet<Option>();
        HashSet<WildcardStates> wildcards = new HashSet<WildcardStates>();
        if ((id & 1) != 0) {
            opts.add(Option.IGNORE_UNAVAILABLE);
        }
        if ((id & 2) != 0) {
            opts.add(Option.ALLOW_NO_INDICES);
        }
        if ((id & 4) != 0) {
            wildcards.add(WildcardStates.OPEN);
        }
        if ((id & 8) != 0) {
            wildcards.add(WildcardStates.CLOSED);
        }
        if ((id & 0x10) != 0) {
            opts.add(Option.FORBID_ALIASES_TO_MULTIPLE_INDICES);
        }
        if ((id & 0x20) != 0) {
            opts.add(Option.FORBID_CLOSED_INDICES);
        }
        if ((id & 0x40) != 0) {
            opts.add(Option.IGNORE_ALIASES);
        }
        return new IndicesOptions(opts, wildcards);
    }

    public boolean ignoreUnavailable() {
        return this.options.contains((Object)Option.IGNORE_UNAVAILABLE);
    }

    public boolean allowNoIndices() {
        return this.options.contains((Object)Option.ALLOW_NO_INDICES);
    }

    public boolean expandWildcardsOpen() {
        return this.expandWildcards.contains((Object)WildcardStates.OPEN);
    }

    public boolean expandWildcardsClosed() {
        return this.expandWildcards.contains((Object)WildcardStates.CLOSED);
    }

    public boolean forbidClosedIndices() {
        return this.options.contains((Object)Option.FORBID_CLOSED_INDICES);
    }

    public boolean allowAliasesToMultipleIndices() {
        return !this.options.contains((Object)Option.FORBID_ALIASES_TO_MULTIPLE_INDICES);
    }

    public boolean ignoreAliases() {
        return this.options.contains((Object)Option.IGNORE_ALIASES);
    }

    public void writeIndicesOptions(StreamOutput out) throws IOException {
        out.writeEnumSet(this.options);
        out.writeEnumSet(this.expandWildcards);
    }

    public static IndicesOptions readIndicesOptions(StreamInput in) throws IOException {
        return new IndicesOptions(in.readEnumSet(Option.class), in.readEnumSet(WildcardStates.class));
    }

    public static IndicesOptions fromOptions(boolean ignoreUnavailable, boolean allowNoIndices, boolean expandToOpenIndices, boolean expandToClosedIndices) {
        return IndicesOptions.fromOptions(ignoreUnavailable, allowNoIndices, expandToOpenIndices, expandToClosedIndices, true, false, false);
    }

    public static IndicesOptions fromOptions(boolean ignoreUnavailable, boolean allowNoIndices, boolean expandToOpenIndices, boolean expandToClosedIndices, IndicesOptions defaultOptions) {
        return IndicesOptions.fromOptions(ignoreUnavailable, allowNoIndices, expandToOpenIndices, expandToClosedIndices, defaultOptions.allowAliasesToMultipleIndices(), defaultOptions.forbidClosedIndices(), defaultOptions.ignoreAliases());
    }

    public static IndicesOptions fromOptions(boolean ignoreUnavailable, boolean allowNoIndices, boolean expandToOpenIndices, boolean expandToClosedIndices, boolean allowAliasesToMultipleIndices, boolean forbidClosedIndices, boolean ignoreAliases) {
        HashSet<Option> opts = new HashSet<Option>();
        HashSet<WildcardStates> wildcards = new HashSet<WildcardStates>();
        if (ignoreUnavailable) {
            opts.add(Option.IGNORE_UNAVAILABLE);
        }
        if (allowNoIndices) {
            opts.add(Option.ALLOW_NO_INDICES);
        }
        if (expandToOpenIndices) {
            wildcards.add(WildcardStates.OPEN);
        }
        if (expandToClosedIndices) {
            wildcards.add(WildcardStates.CLOSED);
        }
        if (!allowAliasesToMultipleIndices) {
            opts.add(Option.FORBID_ALIASES_TO_MULTIPLE_INDICES);
        }
        if (forbidClosedIndices) {
            opts.add(Option.FORBID_CLOSED_INDICES);
        }
        if (ignoreAliases) {
            opts.add(Option.IGNORE_ALIASES);
        }
        return new IndicesOptions(opts, wildcards);
    }

    public static IndicesOptions fromMap(Map<String, Object> map, IndicesOptions defaultSettings) {
        return IndicesOptions.fromParameters(map.containsKey("expand_wildcards") ? map.get("expand_wildcards") : map.get("expandWildcards"), map.containsKey("ignore_unavailable") ? map.get("ignore_unavailable") : map.get("ignoreUnavailable"), map.containsKey("allow_no_indices") ? map.get("allow_no_indices") : map.get("allowNoIndices"), defaultSettings);
    }

    public static boolean isIndicesOptions(String name) {
        return "expand_wildcards".equals(name) || "expandWildcards".equals(name) || "ignore_unavailable".equals(name) || "ignoreUnavailable".equals(name) || "allow_no_indices".equals(name) || "allowNoIndices".equals(name);
    }

    public static IndicesOptions fromParameters(Object wildcardsString, Object ignoreUnavailableString, Object allowNoIndicesString, IndicesOptions defaultSettings) {
        if (wildcardsString == null && ignoreUnavailableString == null && allowNoIndicesString == null) {
            return defaultSettings;
        }
        EnumSet<WildcardStates> wildcards = WildcardStates.parseParameter(wildcardsString, defaultSettings.expandWildcards);
        return IndicesOptions.fromOptions(XContentMapValues.nodeBooleanValue(ignoreUnavailableString, "ignore_unavailable", defaultSettings.ignoreUnavailable()), XContentMapValues.nodeBooleanValue(allowNoIndicesString, "allow_no_indices", defaultSettings.allowNoIndices()), wildcards.contains((Object)WildcardStates.OPEN), wildcards.contains((Object)WildcardStates.CLOSED), defaultSettings.allowAliasesToMultipleIndices(), defaultSettings.forbidClosedIndices(), defaultSettings.ignoreAliases());
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray("expand_wildcards");
        for (WildcardStates expandWildcard : this.expandWildcards) {
            builder.value(expandWildcard.toString().toLowerCase(Locale.ROOT));
        }
        builder.endArray();
        builder.field("ignore_unavailable", this.ignoreUnavailable());
        builder.field("allow_no_indices", this.allowNoIndices());
        return builder;
    }

    public static IndicesOptions strictExpandOpen() {
        return STRICT_EXPAND_OPEN;
    }

    public static IndicesOptions strictExpandOpenAndForbidClosed() {
        return STRICT_EXPAND_OPEN_FORBID_CLOSED;
    }

    public static IndicesOptions strictExpand() {
        return STRICT_EXPAND_OPEN_CLOSED;
    }

    public static IndicesOptions strictSingleIndexNoExpandForbidClosed() {
        return STRICT_SINGLE_INDEX_NO_EXPAND_FORBID_CLOSED;
    }

    public static IndicesOptions lenientExpandOpen() {
        return LENIENT_EXPAND_OPEN;
    }

    public static IndicesOptions lenientExpand() {
        return LENIENT_EXPAND_OPEN_CLOSED;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        IndicesOptions other = (IndicesOptions)obj;
        return this.options.equals(other.options) && this.expandWildcards.equals(other.expandWildcards);
    }

    public int hashCode() {
        int result = this.options.hashCode();
        return 31 * result + this.expandWildcards.hashCode();
    }

    public String toString() {
        return "IndicesOptions[ignore_unavailable=" + this.ignoreUnavailable() + ", allow_no_indices=" + this.allowNoIndices() + ", expand_wildcards_open=" + this.expandWildcardsOpen() + ", expand_wildcards_closed=" + this.expandWildcardsClosed() + ", allow_aliases_to_multiple_indices=" + this.allowAliasesToMultipleIndices() + ", forbid_closed_indices=" + this.forbidClosedIndices() + ", ignore_aliases=" + this.ignoreAliases() + "]";
    }

    public static enum Option {
        IGNORE_UNAVAILABLE,
        IGNORE_ALIASES,
        ALLOW_NO_INDICES,
        FORBID_ALIASES_TO_MULTIPLE_INDICES,
        FORBID_CLOSED_INDICES;

        public static final EnumSet<Option> NONE;

        static {
            NONE = EnumSet.noneOf(Option.class);
        }
    }

    public static enum WildcardStates {
        OPEN,
        CLOSED;

        public static final EnumSet<WildcardStates> NONE;

        public static EnumSet<WildcardStates> parseParameter(Object value, EnumSet<WildcardStates> defaultStates) {
            String[] wildcards;
            if (value == null) {
                return defaultStates;
            }
            HashSet<WildcardStates> states = new HashSet<WildcardStates>();
            for (String wildcard : wildcards = XContentMapValues.nodeStringArrayValue(value)) {
                if ("open".equals(wildcard)) {
                    states.add(OPEN);
                    continue;
                }
                if ("closed".equals(wildcard)) {
                    states.add(CLOSED);
                    continue;
                }
                if ("none".equals(wildcard)) {
                    states.clear();
                    continue;
                }
                if ("all".equals(wildcard)) {
                    states.add(OPEN);
                    states.add(CLOSED);
                    continue;
                }
                throw new IllegalArgumentException("No valid expand wildcard value [" + wildcard + "]");
            }
            return states.isEmpty() ? NONE : EnumSet.copyOf(states);
        }

        static {
            NONE = EnumSet.noneOf(WildcardStates.class);
        }
    }
}

