/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.resync;

import java.io.IOException;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.resync.ResyncReplicationRequest;
import org.elasticsearch.action.support.replication.ReplicationOperation;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.action.support.replication.TransportWriteAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.PrimaryReplicaSyncer;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public class TransportResyncReplicationAction
extends TransportWriteAction<ResyncReplicationRequest, ResyncReplicationRequest, ReplicationResponse>
implements PrimaryReplicaSyncer.SyncAction {
    private static final String ACTION_NAME = "internal:index/seq_no/resync";

    @Inject
    public TransportResyncReplicationAction(TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction) {
        super(ACTION_NAME, transportService, clusterService, indicesService, threadPool, shardStateAction, ResyncReplicationRequest::new, ResyncReplicationRequest::new, "write", true);
    }

    @Override
    public ClusterBlockLevel indexBlockLevel() {
        return null;
    }

    @Override
    protected ReplicationResponse newResponseInstance(StreamInput in) throws IOException {
        return new ReplicationResponse(in);
    }

    @Override
    protected ReplicationOperation.Replicas<ResyncReplicationRequest> newReplicasProxy() {
        return new ResyncActionReplicasProxy();
    }

    @Override
    protected void shardOperationOnPrimary(ResyncReplicationRequest request, IndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<ResyncReplicationRequest, ReplicationResponse>> listener) {
        ActionListener.completeWith(listener, () -> new TransportWriteAction.WritePrimaryResult<ResyncReplicationRequest, ReplicationResponse>(TransportResyncReplicationAction.performOnPrimary(request, primary), new ReplicationResponse(), null, null, primary));
    }

    public static ResyncReplicationRequest performOnPrimary(ResyncReplicationRequest request, IndexShard primary) {
        return request;
    }

    @Override
    protected TransportWriteAction.WriteReplicaResult<ResyncReplicationRequest> shardOperationOnReplica(ResyncReplicationRequest request, IndexShard replica) throws Exception {
        Translog.Location location = TransportResyncReplicationAction.performOnReplica(request, replica);
        return new TransportWriteAction.WriteReplicaResult<ResyncReplicationRequest>(request, location, null, replica, this.logger);
    }

    public static Translog.Location performOnReplica(ResyncReplicationRequest request, IndexShard replica) throws Exception {
        Translog.Location location = null;
        replica.updateMaxUnsafeAutoIdTimestamp(request.getMaxSeenAutoIdTimestampOnPrimary());
        for (Translog.Operation operation : request.getOperations()) {
            Engine.Result operationResult = replica.applyTranslogOperation(operation, Engine.Operation.Origin.REPLICA);
            if (operationResult.getResultType() == Engine.Result.Type.MAPPING_UPDATE_REQUIRED) {
                throw new TransportReplicationAction.RetryOnReplicaException(replica.shardId(), "Mappings are not available on the replica yet, triggered update: " + operationResult.getRequiredMappingUpdate());
            }
            location = TransportResyncReplicationAction.syncOperationResultOrThrow(operationResult, location);
        }
        if (request.getTrimAboveSeqNo() != -2L) {
            replica.trimOperationOfPreviousPrimaryTerms(request.getTrimAboveSeqNo());
        }
        return location;
    }

    @Override
    public void sync(ResyncReplicationRequest request, Task parentTask, String primaryAllocationId, long primaryTerm, final ActionListener<ReplicationResponse> listener) {
        this.transportService.sendChildRequest(this.clusterService.localNode(), this.transportPrimaryAction, new TransportReplicationAction.ConcreteShardRequest<ResyncReplicationRequest>(request, primaryAllocationId, primaryTerm), parentTask, this.transportOptions, new TransportResponseHandler<ReplicationResponse>(){

            @Override
            public ReplicationResponse read(StreamInput in) throws IOException {
                return TransportResyncReplicationAction.this.newResponseInstance(in);
            }

            @Override
            public String executor() {
                return "same";
            }

            @Override
            public void handleResponse(ReplicationResponse response) {
                ReplicationResponse.ShardInfo.Failure[] failures = response.getShardInfo().getFailures();
                for (int i = 0; i < failures.length; ++i) {
                    ReplicationResponse.ShardInfo.Failure f = failures[i];
                    TransportResyncReplicationAction.this.logger.info((Message)new ParameterizedMessage("{} primary-replica resync to replica on node [{}] failed", (Object)f.fullShardId(), (Object)f.nodeId()), f.getCause());
                }
                listener.onResponse(response);
            }

            @Override
            public void handleException(TransportException exp) {
                listener.onFailure(exp);
            }
        });
    }

    class ResyncActionReplicasProxy
    extends TransportReplicationAction.ReplicasProxy {
        ResyncActionReplicasProxy() {
            super(TransportResyncReplicationAction.this);
        }

        @Override
        public void failShardIfNeeded(ShardRouting replica, long primaryTerm, String message, Exception exception, ActionListener<Void> listener) {
            TransportResyncReplicationAction.this.shardStateAction.remoteShardFailed(replica.shardId(), replica.allocationId().getId(), primaryTerm, false, message, exception, listener);
        }
    }
}

