/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import io.crate.common.unit.TimeValue;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class BackoffPolicy
implements Iterable<TimeValue> {
    public static BackoffPolicy exponentialBackoff() {
        return BackoffPolicy.exponentialBackoff(TimeValue.timeValueMillis(50L), 8);
    }

    public static BackoffPolicy exponentialBackoff(TimeValue initialDelay, int maxNumberOfRetries) {
        return new ExponentialBackoff((int)BackoffPolicy.checkDelay(initialDelay).millis(), maxNumberOfRetries);
    }

    private static TimeValue checkDelay(TimeValue delay) {
        if (delay.millis() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("delay must be <= 2147483647 ms");
        }
        return delay;
    }

    private static class ExponentialBackoff
    extends BackoffPolicy {
        private final int start;
        private final int numberOfElements;

        private ExponentialBackoff(int start, int numberOfElements) {
            assert (start >= 0);
            assert (numberOfElements >= 0);
            this.start = start;
            this.numberOfElements = numberOfElements;
        }

        @Override
        public Iterator<TimeValue> iterator() {
            return new ExponentialBackoffIterator(this.start, this.numberOfElements);
        }
    }

    private static class ExponentialBackoffIterator
    implements Iterator<TimeValue> {
        private final int numberOfElements;
        private final int start;
        private int currentlyConsumed;

        private ExponentialBackoffIterator(int start, int numberOfElements) {
            this.start = start;
            this.numberOfElements = numberOfElements;
        }

        @Override
        public boolean hasNext() {
            return this.currentlyConsumed < this.numberOfElements;
        }

        @Override
        public TimeValue next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Only up to " + this.numberOfElements + " elements");
            }
            int result = this.start + 10 * ((int)Math.exp(0.8 * (double)this.currentlyConsumed) - 1);
            ++this.currentlyConsumed;
            return TimeValue.timeValueMillis(result);
        }
    }
}

