/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.upgrade.post;

import io.crate.common.collections.Tuple;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class UpgradeResponse
extends BroadcastResponse {
    private final Map<String, Tuple<Version, String>> versions;

    UpgradeResponse(Map<String, Tuple<Version, String>> versions, int totalShards, int successfulShards, int failedShards, List<DefaultShardOperationFailedException> shardFailures) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.versions = versions;
    }

    public UpgradeResponse(StreamInput in) throws IOException {
        super(in);
        int size = in.readVInt();
        this.versions = new HashMap<String, Tuple<Version, String>>();
        for (int i = 0; i < size; ++i) {
            String index = in.readString();
            Version upgradeVersion = Version.readVersion(in);
            String oldestLuceneSegment = in.readString();
            this.versions.put(index, new Tuple<Version, String>(upgradeVersion, oldestLuceneSegment));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.versions.size());
        for (Map.Entry<String, Tuple<Version, String>> entry : this.versions.entrySet()) {
            out.writeString(entry.getKey());
            Version.writeVersion(entry.getValue().v1(), out);
            out.writeString(entry.getValue().v2());
        }
    }

    public Map<String, Tuple<Version, String>> versions() {
        return this.versions;
    }
}

