/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.upgrade.post;

import io.crate.common.collections.Tuple;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.PrimaryMissingActionException;
import org.elasticsearch.action.admin.indices.upgrade.post.ShardUpgradeResult;
import org.elasticsearch.action.admin.indices.upgrade.post.TransportUpgradeSettingsAction;
import org.elasticsearch.action.admin.indices.upgrade.post.UpgradeRequest;
import org.elasticsearch.action.admin.indices.upgrade.post.UpgradeResponse;
import org.elasticsearch.action.admin.indices.upgrade.post.UpgradeSettingsRequest;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.node.TransportBroadcastByNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public class TransportUpgradeAction
extends TransportBroadcastByNodeAction<UpgradeRequest, UpgradeResponse, ShardUpgradeResult> {
    private final IndicesService indicesService;
    private final TransportUpgradeSettingsAction upgradeSettingsAction;

    @Inject
    public TransportUpgradeAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, IndexNameExpressionResolver indexNameExpressionResolver, TransportUpgradeSettingsAction upgradeSettingsAction) {
        super("indices:admin/upgrade", clusterService, transportService, indexNameExpressionResolver, UpgradeRequest::new, "force_merge", true);
        this.indicesService = indicesService;
        this.upgradeSettingsAction = upgradeSettingsAction;
    }

    @Override
    protected UpgradeResponse newResponse(UpgradeRequest request, int totalShards, int successfulShards, int failedShards, List<ShardUpgradeResult> shardUpgradeResults, List<DefaultShardOperationFailedException> shardFailures, ClusterState clusterState) {
        HashMap<String, Integer> successfulPrimaryShards = new HashMap<String, Integer>();
        HashMap<String, Tuple<Version, org.apache.lucene.util.Version>> versions = new HashMap<String, Tuple<Version, org.apache.lucene.util.Version>>();
        for (ShardUpgradeResult result : shardUpgradeResults) {
            Tuple versionTuple;
            ++successfulShards;
            String index = result.getShardId().getIndex().getName();
            if (result.primary()) {
                Integer count = (Integer)successfulPrimaryShards.get(index);
                successfulPrimaryShards.put(index, count == null ? 1 : count + 1);
            }
            if ((versionTuple = (Tuple)versions.get(index)) == null) {
                versions.put(index, new Tuple<Version, org.apache.lucene.util.Version>(result.upgradeVersion(), result.oldestLuceneSegment()));
                continue;
            }
            Version version = (Version)versionTuple.v1();
            org.apache.lucene.util.Version luceneVersion = (org.apache.lucene.util.Version)versionTuple.v2();
            if (result.upgradeVersion().after((Version)versionTuple.v1())) {
                version = result.upgradeVersion();
            }
            if (!result.oldestLuceneSegment().onOrAfter((org.apache.lucene.util.Version)versionTuple.v2())) {
                luceneVersion = result.oldestLuceneSegment();
            }
            versions.put(index, new Tuple<Version, org.apache.lucene.util.Version>(version, luceneVersion));
        }
        HashMap<String, Tuple<Version, String>> updatedVersions = new HashMap<String, Tuple<Version, String>>();
        Metadata metadata = clusterState.metadata();
        for (Map.Entry versionEntry : versions.entrySet()) {
            String index = (String)versionEntry.getKey();
            Integer primaryCount = (Integer)successfulPrimaryShards.get(index);
            int expectedPrimaryCount = metadata.index(index).getNumberOfShards();
            if (primaryCount.intValue() == metadata.index(index).getNumberOfShards()) {
                updatedVersions.put(index, new Tuple<Version, String>((Version)((Tuple)versionEntry.getValue()).v1(), ((org.apache.lucene.util.Version)((Tuple)versionEntry.getValue()).v2()).toString()));
                continue;
            }
            this.logger.warn("Not updating settings for the index [{}] because upgraded of some primary shards failed - expected[{}], received[{}]", (Object)index, (Object)expectedPrimaryCount, (Object)(primaryCount == null ? 0 : primaryCount));
        }
        return new UpgradeResponse(updatedVersions, totalShards, successfulShards, failedShards, shardFailures);
    }

    @Override
    protected ShardUpgradeResult shardOperation(UpgradeRequest request, ShardRouting shardRouting) throws IOException {
        IndexShard indexShard = this.indicesService.indexServiceSafe(shardRouting.shardId().getIndex()).getShard(shardRouting.shardId().id());
        org.apache.lucene.util.Version oldestLuceneSegment = indexShard.upgrade(request);
        return new ShardUpgradeResult(shardRouting.shardId(), indexShard.routingEntry().primary(), Version.CURRENT, oldestLuceneSegment);
    }

    @Override
    protected ShardUpgradeResult readShardResult(StreamInput in) throws IOException {
        return new ShardUpgradeResult(in);
    }

    @Override
    protected UpgradeRequest readRequestFrom(StreamInput in) throws IOException {
        return new UpgradeRequest(in);
    }

    @Override
    protected ShardsIterator shards(ClusterState clusterState, UpgradeRequest request, String[] concreteIndices) {
        ShardsIterator iterator = clusterState.routingTable().allShards(concreteIndices);
        Set<String> indicesWithMissingPrimaries = this.indicesWithMissingPrimaries(clusterState, concreteIndices);
        if (indicesWithMissingPrimaries.isEmpty()) {
            return iterator;
        }
        throw new PrimaryMissingActionException("Cannot upgrade indices because the following indices are missing primary shards " + indicesWithMissingPrimaries);
    }

    private Set<String> indicesWithMissingPrimaries(ClusterState clusterState, String[] concreteIndices) {
        HashSet<String> indices = new HashSet<String>();
        RoutingTable routingTable = clusterState.routingTable();
        for (String index : concreteIndices) {
            IndexRoutingTable indexRoutingTable = routingTable.index(index);
            if (indexRoutingTable.allPrimaryShardsActive()) continue;
            indices.add(index);
        }
        return indices;
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, UpgradeRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, UpgradeRequest request, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, concreteIndices);
    }

    @Override
    protected void doExecute(Task task, UpgradeRequest request, final ActionListener<UpgradeResponse> listener) {
        ActionListener<UpgradeResponse> settingsUpdateListener = new ActionListener<UpgradeResponse>(){

            @Override
            public void onResponse(UpgradeResponse upgradeResponse) {
                try {
                    if (upgradeResponse.versions().isEmpty()) {
                        listener.onResponse(upgradeResponse);
                    } else {
                        TransportUpgradeAction.this.updateSettings(upgradeResponse, listener);
                    }
                }
                catch (Exception e) {
                    listener.onFailure(e);
                }
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        };
        super.doExecute(task, request, settingsUpdateListener);
    }

    private void updateSettings(UpgradeResponse upgradeResponse, ActionListener<UpgradeResponse> listener) {
        UpgradeSettingsRequest upgradeSettingsRequest = new UpgradeSettingsRequest(upgradeResponse.versions());
        this.upgradeSettingsAction.execute(upgradeSettingsRequest, ActionListener.delegateFailure(listener, (delegatedListener, updateSettingsResponse) -> delegatedListener.onResponse(upgradeResponse)));
    }
}

