/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.put;

import io.crate.common.collections.MapBuilder;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.support.XContentMapValues;

public class PutIndexTemplateRequest
extends MasterNodeRequest<PutIndexTemplateRequest>
implements IndicesRequest {
    private String name;
    private String cause = "";
    private List<String> indexPatterns;
    private int order;
    private boolean create;
    private Settings settings = Settings.Builder.EMPTY_SETTINGS;
    private Map<String, String> mappings = new HashMap<String, String>();
    private final Set<Alias> aliases = new HashSet<Alias>();
    private Integer version;

    public PutIndexTemplateRequest() {
    }

    public PutIndexTemplateRequest(String name) {
        this.name = name;
    }

    public PutIndexTemplateRequest name(String name) {
        this.name = name;
        return this;
    }

    public String name() {
        return this.name;
    }

    public PutIndexTemplateRequest patterns(List<String> indexPatterns) {
        this.indexPatterns = indexPatterns;
        return this;
    }

    public List<String> patterns() {
        return this.indexPatterns;
    }

    public PutIndexTemplateRequest order(int order) {
        this.order = order;
        return this;
    }

    public int order() {
        return this.order;
    }

    public PutIndexTemplateRequest version(Integer version) {
        this.version = version;
        return this;
    }

    public Integer version() {
        return this.version;
    }

    public PutIndexTemplateRequest create(boolean create) {
        this.create = create;
        return this;
    }

    public boolean create() {
        return this.create;
    }

    public PutIndexTemplateRequest settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public PutIndexTemplateRequest settings(Settings.Builder settings) {
        this.settings = settings.build();
        return this;
    }

    public PutIndexTemplateRequest settings(String source, XContentType xContentType) {
        this.settings = Settings.builder().loadFromSource(source, xContentType).build();
        return this;
    }

    public PutIndexTemplateRequest settings(Map<String, Object> source) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(source);
            this.settings(Strings.toString(builder), XContentType.JSON);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + source + "]", e);
        }
        return this;
    }

    public Settings settings() {
        return this.settings;
    }

    public PutIndexTemplateRequest mapping(String type, String source, XContentType xContentType) {
        return this.mapping(type, new BytesArray(source), xContentType);
    }

    public PutIndexTemplateRequest cause(String cause) {
        this.cause = cause;
        return this;
    }

    public String cause() {
        return this.cause;
    }

    public PutIndexTemplateRequest mapping(String type, XContentBuilder source) {
        return this.mapping(type, BytesReference.bytes(source), source.contentType());
    }

    public PutIndexTemplateRequest mapping(String type, BytesReference source, XContentType xContentType) {
        Objects.requireNonNull(xContentType);
        try {
            this.mappings.put(type, XContentHelper.convertToJson(source, xContentType));
            return this;
        }
        catch (IOException e) {
            throw new UncheckedIOException("failed to convert source to json", e);
        }
    }

    public PutIndexTemplateRequest mapping(String type, Map<String, Object> source) {
        if (source.size() != 1 || !source.containsKey(type)) {
            source = MapBuilder.newMapBuilder().put(type, source).map();
        }
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(source);
            return this.mapping(type, builder);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + source + "]", e);
        }
    }

    public PutIndexTemplateRequest mapping(String type, Object ... source) {
        this.mapping(type, PutMappingRequest.buildFromSimplifiedDef(type, source));
        return this;
    }

    public Map<String, String> mappings() {
        return this.mappings;
    }

    public PutIndexTemplateRequest source(XContentBuilder templateBuilder) {
        try {
            return this.source(BytesReference.bytes(templateBuilder), templateBuilder.contentType());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to build json for template request", e);
        }
    }

    public PutIndexTemplateRequest source(Map templateSource) {
        Map source = templateSource;
        for (Map.Entry entry : source.entrySet()) {
            String name = (String)entry.getKey();
            if (name.equals("index_patterns")) {
                if (entry.getValue() instanceof String) {
                    this.patterns(Collections.singletonList((String)entry.getValue()));
                    continue;
                }
                if (entry.getValue() instanceof List) {
                    List<String> elements = ((List)entry.getValue()).stream().map(Object::toString).collect(Collectors.toList());
                    this.patterns(elements);
                    continue;
                }
                throw new IllegalArgumentException("Malformed [template] value, should be a string or a list of strings");
            }
            if (name.equals("order")) {
                this.order(XContentMapValues.nodeIntegerValue(entry.getValue(), this.order()));
                continue;
            }
            if ("version".equals(name)) {
                if (!(entry.getValue() instanceof Integer)) {
                    throw new IllegalArgumentException("Malformed [version] value, should be an integer");
                }
                this.version((Integer)entry.getValue());
                continue;
            }
            if (name.equals("settings")) {
                if (!(entry.getValue() instanceof Map)) {
                    throw new IllegalArgumentException("Malformed [settings] section, should include an inner object");
                }
                this.settings((Map)entry.getValue());
                continue;
            }
            if (name.equals("mappings")) {
                Map mappings = (Map)entry.getValue();
                for (Map.Entry entry1 : mappings.entrySet()) {
                    if (!(entry1.getValue() instanceof Map)) {
                        throw new IllegalArgumentException("Malformed [mappings] section for type [" + (String)entry1.getKey() + "], should include an inner object describing the mapping");
                    }
                    this.mapping((String)entry1.getKey(), (Map)entry1.getValue());
                }
                continue;
            }
            if (name.equals("aliases")) {
                this.aliases((Map)entry.getValue());
                continue;
            }
            throw new ElasticsearchParseException("unknown key [{}] in the template ", name);
        }
        return this;
    }

    public PutIndexTemplateRequest source(String templateSource, XContentType xContentType) {
        return this.source(XContentHelper.convertToMap(xContentType.xContent(), templateSource, true));
    }

    public PutIndexTemplateRequest source(byte[] source, XContentType xContentType) {
        return this.source(source, 0, source.length, xContentType);
    }

    public PutIndexTemplateRequest source(byte[] source, int offset, int length, XContentType xContentType) {
        return this.source(new BytesArray(source, offset, length), xContentType);
    }

    public PutIndexTemplateRequest source(BytesReference source, XContentType xContentType) {
        return this.source(XContentHelper.convertToMap(source, true, xContentType).v2());
    }

    public Set<Alias> aliases() {
        return this.aliases;
    }

    public PutIndexTemplateRequest aliases(Map source) {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.map(source);
            return this.aliases(BytesReference.bytes(builder));
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + source + "]", e);
        }
    }

    public PutIndexTemplateRequest aliases(XContentBuilder source) {
        return this.aliases(BytesReference.bytes(source));
    }

    public PutIndexTemplateRequest aliases(String source) {
        return this.aliases(new BytesArray(source));
    }

    public PutIndexTemplateRequest aliases(BytesReference source) {
        PutIndexTemplateRequest putIndexTemplateRequest;
        block9: {
            XContentParser parser = XContentHelper.createParser(NamedXContentRegistry.EMPTY, LoggingDeprecationHandler.INSTANCE, source);
            try {
                parser.nextToken();
                while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                    this.alias(Alias.fromXContent(parser));
                }
                putIndexTemplateRequest = this;
                if (parser == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("Failed to parse aliases", (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return putIndexTemplateRequest;
    }

    public PutIndexTemplateRequest alias(Alias alias) {
        this.aliases.add(alias);
        return this;
    }

    @Override
    public String[] indices() {
        return this.indexPatterns.toArray(new String[this.indexPatterns.size()]);
    }

    @Override
    public IndicesOptions indicesOptions() {
        return IndicesOptions.strictExpand();
    }

    public PutIndexTemplateRequest(StreamInput in) throws IOException {
        super(in);
        this.cause = in.readString();
        this.name = in.readString();
        this.indexPatterns = in.readList(StreamInput::readString);
        this.order = in.readInt();
        this.create = in.readBoolean();
        this.settings = Settings.readSettingsFromStream(in);
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            String type = in.readString();
            String mappingSource = in.readString();
            this.mappings.put(type, mappingSource);
        }
        int aliasesSize = in.readVInt();
        for (int i = 0; i < aliasesSize; ++i) {
            this.aliases.add(new Alias(in));
        }
        this.version = in.readOptionalVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.cause);
        out.writeString(this.name);
        out.writeStringCollection(this.indexPatterns);
        out.writeInt(this.order);
        out.writeBoolean(this.create);
        Settings.writeSettingsToStream(this.settings, out);
        out.writeVInt(this.mappings.size());
        for (Map.Entry<String, String> entry : this.mappings.entrySet()) {
            out.writeString(entry.getKey());
            out.writeString(entry.getValue());
        }
        out.writeVInt(this.aliases.size());
        for (Alias alias : this.aliases) {
            alias.writeTo(out);
        }
        out.writeOptionalVInt(this.version);
    }
}

