/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.delete;

import java.io.IOException;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.template.delete.DeleteIndexTemplateRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDeleteIndexTemplateAction
extends TransportMasterNodeAction<DeleteIndexTemplateRequest, AcknowledgedResponse> {
    private final MetadataIndexTemplateService indexTemplateService;

    @Inject
    public TransportDeleteIndexTemplateAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataIndexTemplateService indexTemplateService, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:admin/template/delete", transportService, clusterService, threadPool, DeleteIndexTemplateRequest::new, indexNameExpressionResolver);
        this.indexTemplateService = indexTemplateService;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(DeleteIndexTemplateRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    @Override
    protected void masterOperation(Task task, final DeleteIndexTemplateRequest request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) {
        this.indexTemplateService.removeTemplates(new MetadataIndexTemplateService.RemoveRequest(request.name()).masterTimeout(request.masterNodeTimeout()), new MetadataIndexTemplateService.RemoveListener(){

            @Override
            public void onResponse(MetadataIndexTemplateService.RemoveResponse response) {
                listener.onResponse(new AcknowledgedResponse(response.acknowledged()));
            }

            @Override
            public void onFailure(Exception e) {
                TransportDeleteIndexTemplateAction.this.logger.debug(() -> new ParameterizedMessage("failed to delete templates [{}]", (Object)request.name()), (Throwable)e);
                listener.onFailure(e);
            }
        });
    }
}

