/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.stats;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.shard.DocsStats;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.store.StoreStats;

public class CommonStats
implements Writeable {
    @Nullable
    public DocsStats docs;
    @Nullable
    public StoreStats store;

    public CommonStats() {
        this(CommonStatsFlags.NONE);
    }

    public CommonStats(CommonStatsFlags flags) {
        CommonStatsFlags.Flag[] setFlags;
        block4: for (CommonStatsFlags.Flag flag : setFlags = flags.getFlags()) {
            switch (flag) {
                case Docs: {
                    this.docs = new DocsStats();
                    continue block4;
                }
                case Store: {
                    this.store = new StoreStats();
                    continue block4;
                }
                default: {
                    throw new IllegalStateException("Unknown Flag: " + flag);
                }
            }
        }
    }

    public CommonStats(IndexShard indexShard, CommonStatsFlags flags) {
        CommonStatsFlags.Flag[] setFlags;
        for (CommonStatsFlags.Flag flag : setFlags = flags.getFlags()) {
            try {
                switch (flag) {
                    case Docs: {
                        this.docs = indexShard.docStats();
                        break;
                    }
                    case Store: {
                        this.store = indexShard.storeStats();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown Flag: " + flag);
                    }
                }
            }
            catch (AlreadyClosedException alreadyClosedException) {
                // empty catch block
            }
        }
    }

    public CommonStats(StreamInput in) throws IOException {
        this.docs = in.readOptionalWriteable(DocsStats::new);
        this.store = in.readOptionalWriteable(StoreStats::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.docs);
        out.writeOptionalWriteable(this.store);
    }

    public void add(CommonStats stats) {
        if (this.docs == null) {
            if (stats.getDocs() != null) {
                this.docs = new DocsStats();
                this.docs.add(stats.getDocs());
            }
        } else {
            this.docs.add(stats.getDocs());
        }
        if (this.store == null) {
            if (stats.getStore() != null) {
                this.store = new StoreStats();
                this.store.add(stats.getStore());
            }
        } else {
            this.store.add(stats.getStore());
        }
    }

    @Nullable
    public DocsStats getDocs() {
        return this.docs;
    }

    @Nullable
    public StoreStats getStore() {
        return this.store;
    }
}

