/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.shrink;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.shrink.ResizeType;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;

public class ResizeRequest
extends AcknowledgedRequest<ResizeRequest>
implements IndicesRequest {
    public static final ObjectParser<ResizeRequest, Void> PARSER = new ObjectParser("resize_request", null);
    private CreateIndexRequest targetIndexRequest;
    private String sourceIndex;
    private ResizeType type = ResizeType.SHRINK;
    private Boolean copySettings;

    ResizeRequest() {
    }

    public ResizeRequest(String targetIndex, String sourceIndex) {
        this.targetIndexRequest = new CreateIndexRequest(targetIndex);
        this.sourceIndex = sourceIndex;
    }

    public void setSourceIndex(String index) {
        this.sourceIndex = index;
    }

    public ResizeRequest(StreamInput in) throws IOException {
        super(in);
        this.targetIndexRequest = new CreateIndexRequest(in);
        this.sourceIndex = in.readString();
        this.type = in.readEnum(ResizeType.class);
        this.copySettings = in.readOptionalBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.targetIndexRequest.writeTo(out);
        out.writeString(this.sourceIndex);
        out.writeEnum(this.type);
        out.writeOptionalBoolean(this.copySettings);
    }

    @Override
    public String[] indices() {
        return new String[]{this.sourceIndex};
    }

    @Override
    public IndicesOptions indicesOptions() {
        return IndicesOptions.lenientExpandOpen();
    }

    public void setTargetIndex(CreateIndexRequest targetIndexRequest) {
        this.targetIndexRequest = Objects.requireNonNull(targetIndexRequest, "target index request must not be null");
    }

    public CreateIndexRequest getTargetIndexRequest() {
        return this.targetIndexRequest;
    }

    public String getSourceIndex() {
        return this.sourceIndex;
    }

    public void setWaitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.getTargetIndexRequest().waitForActiveShards(waitForActiveShards);
    }

    public void setWaitForActiveShards(int waitForActiveShards) {
        this.setWaitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }

    public void setResizeType(ResizeType type) {
        this.type = Objects.requireNonNull(type);
    }

    public ResizeType getResizeType() {
        return this.type;
    }

    public void setCopySettings(Boolean copySettings) {
        if (copySettings != null && !copySettings.booleanValue()) {
            throw new IllegalArgumentException("[copySettings] can not be explicitly set to [false]");
        }
        this.copySettings = copySettings;
    }

    public Boolean getCopySettings() {
        return this.copySettings;
    }

    public void fromXContent(XContentParser parser) throws IOException {
        PARSER.parse(parser, this, null);
    }

    static {
        PARSER.declareField((parser, request, context) -> request.getTargetIndexRequest().settings(parser.map()), new ParseField("settings", new String[0]), ObjectParser.ValueType.OBJECT);
        PARSER.declareField((parser, request, context) -> request.getTargetIndexRequest().aliases(parser.map()), new ParseField("aliases", new String[0]), ObjectParser.ValueType.OBJECT);
    }
}

