/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.recovery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.indices.recovery.RecoveryState;

public class RecoveryResponse
extends BroadcastResponse {
    private final Map<String, List<RecoveryState>> shardRecoveryStates;

    public RecoveryResponse(int totalShards, int successfulShards, int failedShards, Map<String, List<RecoveryState>> shardRecoveryStates, List<DefaultShardOperationFailedException> shardFailures) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.shardRecoveryStates = shardRecoveryStates;
    }

    public boolean hasRecoveries() {
        return this.shardRecoveryStates.size() > 0;
    }

    public Map<String, List<RecoveryState>> shardRecoveryStates() {
        return this.shardRecoveryStates;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.shardRecoveryStates.size());
        for (Map.Entry<String, List<RecoveryState>> entry : this.shardRecoveryStates.entrySet()) {
            out.writeString(entry.getKey());
            out.writeVInt(entry.getValue().size());
            for (RecoveryState recoveryState : entry.getValue()) {
                recoveryState.writeTo(out);
            }
        }
    }

    public RecoveryResponse(StreamInput in) throws IOException {
        super(in);
        int size = in.readVInt();
        this.shardRecoveryStates = new HashMap<String, List<RecoveryState>>();
        for (int i = 0; i < size; ++i) {
            String s = in.readString();
            int listSize = in.readVInt();
            ArrayList<RecoveryState> list = new ArrayList<RecoveryState>(listSize);
            for (int j = 0; j < listSize; ++j) {
                list.add(new RecoveryState(in));
            }
            this.shardRecoveryStates.put(s, list);
        }
    }
}

