/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.mapping.put;

import java.io.IOException;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetadataMappingService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportPutMappingAction
extends TransportMasterNodeAction<PutMappingRequest, AcknowledgedResponse> {
    private final MetadataMappingService metadataMappingService;

    @Inject
    public TransportPutMappingAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataMappingService metadataMappingService, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:admin/mapping/put", transportService, clusterService, threadPool, PutMappingRequest::new, indexNameExpressionResolver);
        this.metadataMappingService = metadataMappingService;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(PutMappingRequest request, ClusterState state) {
        String[] indices = request.getConcreteIndex() == null ? this.indexNameExpressionResolver.concreteIndexNames(state, request) : new String[]{request.getConcreteIndex().getName()};
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, indices);
    }

    @Override
    protected void masterOperation(Task task, PutMappingRequest request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) {
        try {
            Index[] indexArray;
            if (request.getConcreteIndex() == null) {
                indexArray = this.indexNameExpressionResolver.concreteIndices(state, request);
            } else {
                Index[] indexArray2 = new Index[1];
                indexArray = indexArray2;
                indexArray2[0] = request.getConcreteIndex();
            }
            final Index[] concreteIndices = indexArray;
            PutMappingClusterStateUpdateRequest updateRequest = (PutMappingClusterStateUpdateRequest)((PutMappingClusterStateUpdateRequest)((PutMappingClusterStateUpdateRequest)new PutMappingClusterStateUpdateRequest(request.source()).ackTimeout(request.timeout())).masterNodeTimeout(request.masterNodeTimeout())).indices(concreteIndices);
            this.metadataMappingService.putMapping(updateRequest, new ActionListener<ClusterStateUpdateResponse>(){

                @Override
                public void onResponse(ClusterStateUpdateResponse response) {
                    listener.onResponse(new AcknowledgedResponse(response.isAcknowledged()));
                }

                @Override
                public void onFailure(Exception t) {
                    TransportPutMappingAction.this.logger.debug(() -> new ParameterizedMessage("failed to put mappings on indices [{}]", (Object[])concreteIndices), (Throwable)t);
                    listener.onFailure(t);
                }
            });
        }
        catch (IndexNotFoundException ex) {
            this.logger.debug(() -> new ParameterizedMessage("failed to put mappings on indices [{}]", (Object[])request.indices()), (Throwable)ex);
            throw ex;
        }
    }
}

