/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.mapping.put;

import com.carrotsearch.hppc.ObjectHashSet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.Version;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.Index;

public class PutMappingRequest
extends AcknowledgedRequest<PutMappingRequest>
implements IndicesRequest.Replaceable,
ToXContentObject {
    private static ObjectHashSet<String> RESERVED_FIELDS = ObjectHashSet.from((Object[])new String[]{"_uid", "_id", "_type", "_source", "_all", "_analyzer", "_parent", "_routing", "_index", "_size", "_timestamp", "_ttl", "_field_names"});
    private String[] indices;
    private IndicesOptions indicesOptions = IndicesOptions.fromOptions(false, false, true, true);
    private String source;
    private Index concreteIndex;

    public PutMappingRequest() {
    }

    public PutMappingRequest(String ... indices) {
        this.indices = indices;
    }

    @Override
    public PutMappingRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    public PutMappingRequest setConcreteIndex(Index index) {
        Objects.requireNonNull(this.indices, "index must not be null");
        this.concreteIndex = index;
        return this;
    }

    public Index getConcreteIndex() {
        return this.concreteIndex;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public PutMappingRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public String source() {
        return this.source;
    }

    public PutMappingRequest source(Object ... source) {
        return this.source(PutMappingRequest.buildFromSimplifiedDef("default", source));
    }

    public static XContentBuilder buildFromSimplifiedDef(String type, Object ... source) {
        if (source.length % 2 != 0) {
            throw new IllegalArgumentException("mapping source must be pairs of fieldnames and properties definition.");
        }
        try {
            String[] s2;
            String[] s1;
            String fieldName;
            int i;
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.startObject();
            if (type != null) {
                builder.startObject(type);
            }
            for (i = 0; i < source.length; ++i) {
                if (!RESERVED_FIELDS.contains((Object)(fieldName = source[i++].toString()))) continue;
                builder.startObject(fieldName);
                for (String s : s1 = Strings.splitStringByCommaToArray(source[i].toString())) {
                    s2 = Strings.split(s, "=");
                    if (s2.length != 2) {
                        throw new IllegalArgumentException("malformed " + s);
                    }
                    builder.field(s2[0], s2[1]);
                }
                builder.endObject();
            }
            builder.startObject("properties");
            for (i = 0; i < source.length; ++i) {
                if (RESERVED_FIELDS.contains((Object)(fieldName = source[i++].toString()))) continue;
                builder.startObject(fieldName);
                for (String s : s1 = Strings.splitStringByCommaToArray(source[i].toString())) {
                    s2 = Strings.split(s, "=");
                    if (s2.length != 2) {
                        throw new IllegalArgumentException("malformed " + s);
                    }
                    builder.field(s2[0], s2[1]);
                }
                builder.endObject();
            }
            builder.endObject();
            if (type != null) {
                builder.endObject();
            }
            builder.endObject();
            return builder;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to generate simplified mapping definition", e);
        }
    }

    public PutMappingRequest source(XContentBuilder mappingBuilder) {
        return this.source(Strings.toString(mappingBuilder), mappingBuilder.contentType());
    }

    public PutMappingRequest source(Map mappingSource) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(mappingSource);
            return this.source(Strings.toString(builder), XContentType.JSON);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + mappingSource + "]", e);
        }
    }

    public PutMappingRequest source(String mappingSource, XContentType xContentType) {
        return this.source(new BytesArray(mappingSource), xContentType);
    }

    public PutMappingRequest source(BytesReference mappingSource, XContentType xContentType) {
        Objects.requireNonNull(xContentType);
        try {
            this.source = XContentHelper.convertToJson(mappingSource, xContentType);
            return this;
        }
        catch (IOException e) {
            throw new UncheckedIOException("failed to convert source to json", e);
        }
    }

    public PutMappingRequest(StreamInput in) throws IOException {
        super(in);
        String type;
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        if (in.getVersion().before(Version.V_4_4_0) && !"default".equals(type = in.readOptionalString())) {
            throw new IllegalArgumentException("Expected type [default] but received [" + type + "]");
        }
        this.source = in.readString();
        if (in.getVersion().before(Version.V_4_3_0)) {
            in.readBoolean();
        }
        this.concreteIndex = in.readOptionalWriteable(Index::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArrayNullable(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        if (out.getVersion().before(Version.V_4_4_0)) {
            out.writeOptionalString("default");
        }
        out.writeString(this.source);
        if (out.getVersion().before(Version.V_4_3_0)) {
            out.writeBoolean(true);
        }
        out.writeOptionalWriteable(this.concreteIndex);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.source != null) {
            try (StreamInput stream = new BytesArray(this.source).streamInput();){
                builder.rawValue(stream, XContentType.JSON);
            }
        } else {
            builder.startObject().endObject();
        }
        return builder;
    }
}

