/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.flush;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.iterable.Iterables;
import org.elasticsearch.indices.flush.ShardsSyncedFlushResult;
import org.elasticsearch.transport.TransportResponse;

public class SyncedFlushResponse
extends TransportResponse {
    private final Map<String, List<ShardsSyncedFlushResult>> shardsResultPerIndex;
    private final ShardCounts shardCounts;

    public SyncedFlushResponse(Map<String, List<ShardsSyncedFlushResult>> shardsResultPerIndex) {
        this.shardsResultPerIndex = Collections.unmodifiableMap(shardsResultPerIndex);
        this.shardCounts = SyncedFlushResponse.calculateShardCounts(Iterables.flatten(shardsResultPerIndex.values()));
    }

    public int totalShards() {
        return this.shardCounts.total;
    }

    public int failedShards() {
        return this.shardCounts.failed;
    }

    public int successfulShards() {
        return this.shardCounts.successful;
    }

    private static ShardCounts calculateShardCounts(Iterable<ShardsSyncedFlushResult> results) {
        int total = 0;
        int successful = 0;
        int failed = 0;
        for (ShardsSyncedFlushResult result : results) {
            total += result.totalShards();
            successful += result.successfulShards();
            if (result.failed()) {
                failed += result.totalShards();
                continue;
            }
            failed += result.failedShards().size();
        }
        return new ShardCounts(total, successful, failed);
    }

    public SyncedFlushResponse(StreamInput in) throws IOException {
        this.shardCounts = new ShardCounts(in);
        HashMap tmpShardsResultPerIndex = new HashMap();
        int numShardsResults = in.readInt();
        for (int i = 0; i < numShardsResults; ++i) {
            String index = in.readString();
            ArrayList<ShardsSyncedFlushResult> shardsSyncedFlushResults = new ArrayList<ShardsSyncedFlushResult>();
            int numShards = in.readInt();
            for (int j = 0; j < numShards; ++j) {
                shardsSyncedFlushResults.add(new ShardsSyncedFlushResult(in));
            }
            tmpShardsResultPerIndex.put(index, shardsSyncedFlushResults);
        }
        this.shardsResultPerIndex = Collections.unmodifiableMap(tmpShardsResultPerIndex);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.shardCounts.writeTo(out);
        out.writeInt(this.shardsResultPerIndex.size());
        for (Map.Entry<String, List<ShardsSyncedFlushResult>> entry : this.shardsResultPerIndex.entrySet()) {
            out.writeString(entry.getKey());
            out.writeInt(entry.getValue().size());
            for (ShardsSyncedFlushResult shardsSyncedFlushResult : entry.getValue()) {
                shardsSyncedFlushResult.writeTo(out);
            }
        }
    }

    static final class ShardCounts
    implements Writeable {
        public final int total;
        public final int successful;
        public final int failed;

        ShardCounts(int total, int successful, int failed) {
            this.total = total;
            this.successful = successful;
            this.failed = failed;
        }

        public ShardCounts(StreamInput in) throws IOException {
            this.total = in.readInt();
            this.successful = in.readInt();
            this.failed = in.readInt();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeInt(this.total);
            out.writeInt(this.successful);
            out.writeInt(this.failed);
        }
    }
}

