/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.create;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import com.google.common.collect.Iterables;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.metadata.PartitionName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.create.CreatePartitionsRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.ActiveShardsObserver;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.ShardLimitValidator;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Singleton
public class TransportCreatePartitionsAction
extends TransportMasterNodeAction<CreatePartitionsRequest, AcknowledgedResponse> {
    public static final String NAME = "indices:admin/bulk_create";
    private final IndicesService indicesService;
    private final AllocationService allocationService;
    private final NamedXContentRegistry xContentRegistry;
    private final ActiveShardsObserver activeShardsObserver;
    private final ShardLimitValidator shardLimitValidator;
    private final ClusterStateTaskExecutor<CreatePartitionsRequest> executor = (currentState, tasks) -> {
        ClusterStateTaskExecutor.ClusterTasksResult.Builder<CreatePartitionsRequest> builder = ClusterStateTaskExecutor.ClusterTasksResult.builder();
        for (CreatePartitionsRequest request : tasks) {
            try {
                currentState = this.executeCreateIndices(currentState, request);
                builder.success(request);
            }
            catch (Exception e) {
                builder.failure(request, e);
            }
        }
        return builder.build(currentState);
    };

    @Inject
    public TransportCreatePartitionsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, IndicesService indicesService, AllocationService allocationService, NamedXContentRegistry xContentRegistry, IndexNameExpressionResolver indexNameExpressionResolver, ShardLimitValidator shardLimitValidator) {
        super(NAME, transportService, clusterService, threadPool, CreatePartitionsRequest::new, indexNameExpressionResolver);
        this.indicesService = indicesService;
        this.allocationService = allocationService;
        this.xContentRegistry = xContentRegistry;
        this.activeShardsObserver = new ActiveShardsObserver(clusterService, threadPool);
        this.shardLimitValidator = shardLimitValidator;
    }

    @Override
    protected String executor() {
        return "management";
    }

    @Override
    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    @Override
    protected void masterOperation(Task task, CreatePartitionsRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws ElasticsearchException {
        if (request.indices().isEmpty()) {
            listener.onResponse(new AcknowledgedResponse(true));
            return;
        }
        this.createIndices(request, ActionListener.wrap(response -> {
            if (response.isAcknowledged()) {
                this.activeShardsObserver.waitForActiveShards(request.indices().toArray(new String[0]), ActiveShardCount.DEFAULT, request.ackTimeout(), shardsAcked -> {
                    if (!shardsAcked.booleanValue() && this.logger.isInfoEnabled()) {
                        String partitionTemplateName = PartitionName.templateName(request.indices().iterator().next());
                        IndexTemplateMetadata templateMetadata = state.metadata().getTemplates().get(partitionTemplateName);
                        this.logger.info("[{}] Table partitions created, but the operation timed out while waiting for enough shards to be started. Timeout={}, wait_for_active_shards={}. Consider decreasing the 'number_of_shards' table setting (currently: {}) or adding nodes to the cluster.", request.indices(), (Object)request.timeout(), (Object)IndexMetadata.SETTING_WAIT_FOR_ACTIVE_SHARDS.get(templateMetadata.getSettings()), (Object)IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.get(templateMetadata.getSettings()));
                    }
                    listener.onResponse(new AcknowledgedResponse(response.isAcknowledged()));
                }, listener::onFailure);
            } else {
                this.logger.warn("[{}] Table partitions created, but publishing new cluster state timed out. Timeout={}", request.indices(), (Object)request.timeout());
                listener.onResponse(new AcknowledgedResponse(false));
            }
        }, listener::onFailure));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClusterState executeCreateIndices(ClusterState currentState, CreatePartitionsRequest request) throws Exception {
        ClusterState clusterState;
        ArrayList<Index> createdIndices;
        ArrayList<String> removalReasons;
        ArrayList<String> indicesToCreate;
        block18: {
            indicesToCreate = new ArrayList<String>(request.indices().size());
            removalReasons = new ArrayList<String>(request.indices().size());
            createdIndices = new ArrayList<Index>(request.indices().size());
            this.validateAndFilterExistingIndices(currentState, indicesToCreate, request);
            if (!indicesToCreate.isEmpty()) break block18;
            ClusterState clusterState2 = currentState;
            for (int i = 0; i < createdIndices.size(); ++i) {
                String removalReason = removalReasons.size() > i ? (String)removalReasons.get(i) : "failed to create index";
                this.indicesService.removeIndex((Index)createdIndices.get(i), IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.NO_LONGER_ASSIGNED, removalReason);
            }
            return clusterState2;
        }
        try {
            HashMap<String, Map<String, Object>> mappings = new HashMap<String, Map<String, Object>>();
            HashMap<String, AliasMetadata> templatesAliases = new HashMap<String, AliasMetadata>();
            ArrayList<String> templateNames = new ArrayList<String>();
            List<IndexTemplateMetadata> templates = this.findTemplates(request, currentState);
            this.applyTemplates(mappings, templatesAliases, templateNames, templates);
            Metadata.Builder newMetadataBuilder = Metadata.builder(currentState.metadata());
            for (String index : indicesToCreate) {
                IndexMetadata indexMetadata;
                Settings indexSettings = this.createIndexSettings(currentState, templates);
                this.shardLimitValidator.validateShardLimit(indexSettings, currentState);
                int routingNumShards = IndexMetadata.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.get(indexSettings);
                String testIndex = (String)indicesToCreate.get(0);
                IndexMetadata.Builder tmpImdBuilder = IndexMetadata.builder(testIndex).setRoutingNumShards(routingNumShards);
                IndexMetadata tmpImd = tmpImdBuilder.settings(indexSettings).build();
                ActiveShardCount waitForActiveShards = tmpImd.getWaitForActiveShards();
                if (!waitForActiveShards.validate(tmpImd.getNumberOfReplicas())) {
                    throw new IllegalArgumentException("invalid wait_for_active_shards[" + waitForActiveShards + "]: cannot be greater than number of shard copies [" + (tmpImd.getNumberOfReplicas() + 1) + "]");
                }
                IndicesClusterStateService.AllocatedIndex indexService = this.indicesService.createIndex(tmpImd, Collections.emptyList());
                createdIndices.add(((AbstractIndexComponent)((Object)indexService)).index());
                MapperService mapperService = ((IndexService)indexService).mapperService();
                if (!mappings.isEmpty()) {
                    assert (mappings.size() == 1) : "Must have at most 1 mapping type";
                    Map.Entry entry = mappings.entrySet().iterator().next();
                    try {
                        mapperService.merge((String)entry.getKey(), (Map)entry.getValue(), MapperService.MergeReason.MAPPING_UPDATE);
                    }
                    catch (MapperParsingException mpe) {
                        removalReasons.add("failed on parsing mappings on index creation");
                        throw mpe;
                    }
                }
                HashMap<String, MappingMetadata> mappingsMetadata = new HashMap<String, MappingMetadata>();
                DocumentMapper mapper = mapperService.documentMapper();
                if (mapper != null) {
                    MappingMetadata mappingMd = new MappingMetadata(mapper);
                    mappingsMetadata.put(mapper.type(), mappingMd);
                }
                IndexMetadata.Builder indexMetadataBuilder = IndexMetadata.builder(index).setRoutingNumShards(routingNumShards).settings(indexSettings);
                for (MappingMetadata mappingMd : mappingsMetadata.values()) {
                    indexMetadataBuilder.putMapping(mappingMd);
                }
                for (AliasMetadata aliasMetadata : templatesAliases.values()) {
                    indexMetadataBuilder.putAlias(aliasMetadata);
                }
                indexMetadataBuilder.state(IndexMetadata.State.OPEN);
                try {
                    indexMetadata = indexMetadataBuilder.build();
                }
                catch (Exception e) {
                    removalReasons.add("failed to build index metadata");
                    throw e;
                }
                this.logger.info("[{}] creating index, cause [bulk], templates {}, shards [{}]/[{}], mappings {}", (Object)index, templateNames, (Object)indexMetadata.getNumberOfShards(), (Object)indexMetadata.getNumberOfReplicas(), mappings.keySet());
                ((IndexService)indexService).getIndexEventListener().beforeIndexAddedToCluster(indexMetadata.getIndex(), indexMetadata.getSettings());
                newMetadataBuilder.put(indexMetadata, false);
                removalReasons.add("cleaning up after validating index on master");
            }
            Metadata newMetadata = newMetadataBuilder.build();
            ClusterState updatedState = ClusterState.builder(currentState).metadata(newMetadata).build();
            RoutingTable.Builder routingTableBuilder = RoutingTable.builder(updatedState.routingTable());
            for (String index : indicesToCreate) {
                routingTableBuilder.addAsNew(updatedState.metadata().index(index));
            }
            clusterState = this.allocationService.reroute(ClusterState.builder(updatedState).routingTable(routingTableBuilder.build()).build(), "bulk-index-creation");
        }
        catch (Throwable throwable) {
            for (int i = 0; i < createdIndices.size(); ++i) {
                String removalReason = removalReasons.size() > i ? (String)removalReasons.get(i) : "failed to create index";
                this.indicesService.removeIndex((Index)createdIndices.get(i), IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.NO_LONGER_ASSIGNED, removalReason);
            }
            throw throwable;
        }
        for (int i = 0; i < createdIndices.size(); ++i) {
            String removalReason = removalReasons.size() > i ? (String)removalReasons.get(i) : "failed to create index";
            this.indicesService.removeIndex((Index)createdIndices.get(i), IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.NO_LONGER_ASSIGNED, removalReason);
        }
        return clusterState;
    }

    @VisibleForTesting
    void createIndices(final CreatePartitionsRequest request, ActionListener<ClusterStateUpdateResponse> listener) {
        this.clusterService.submitStateUpdateTask("bulk-create-indices", request, ClusterStateTaskConfig.build(Priority.URGENT, request.masterNodeTimeout()), this.executor, new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>((AckedRequest)request, listener){

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                return TransportCreatePartitionsAction.this.executeCreateIndices(currentState, request);
            }

            @Override
            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }
        });
    }

    private void validateAndFilterExistingIndices(ClusterState currentState, List<String> indicesToCreate, CreatePartitionsRequest request) {
        for (String index : request.indices()) {
            try {
                MetadataCreateIndexService.validateIndexName(index, currentState);
                indicesToCreate.add(index);
            }
            catch (ResourceAlreadyExistsException resourceAlreadyExistsException) {}
        }
    }

    private Settings createIndexSettings(ClusterState currentState, List<IndexTemplateMetadata> templates) {
        Settings.Builder indexSettingsBuilder = Settings.builder();
        for (int i = templates.size() - 1; i >= 0; --i) {
            indexSettingsBuilder.put(templates.get(i).settings());
        }
        if (indexSettingsBuilder.get("index.version.created") == null) {
            DiscoveryNodes nodes = currentState.nodes();
            Version createdVersion = Version.min(Version.CURRENT, nodes.getSmallestNonClientNodeVersion());
            indexSettingsBuilder.put("index.version.created", createdVersion);
        }
        if (indexSettingsBuilder.get("index.creation_date") == null) {
            indexSettingsBuilder.put("index.creation_date", new DateTime(DateTimeZone.UTC).getMillis());
        }
        indexSettingsBuilder.put("index.uuid", UUIDs.randomBase64UUID());
        return indexSettingsBuilder.build();
    }

    private void applyTemplates(Map<String, Map<String, Object>> mappings, Map<String, AliasMetadata> templatesAliases, List<String> templateNames, List<IndexTemplateMetadata> templates) throws Exception {
        for (IndexTemplateMetadata template : templates) {
            templateNames.add(template.getName());
            for (ObjectObjectCursor<String, CompressedXContent> objectObjectCursor : template.mappings()) {
                if (mappings.containsKey(objectObjectCursor.key)) {
                    XContentHelper.mergeDefaults(mappings.get(objectObjectCursor.key), this.parseMapping(((CompressedXContent)objectObjectCursor.value).string()));
                    continue;
                }
                mappings.put((String)objectObjectCursor.key, this.parseMapping(((CompressedXContent)objectObjectCursor.value).string()));
            }
            for (ObjectObjectCursor objectObjectCursor : template.aliases()) {
                AliasMetadata aliasMetadata = (AliasMetadata)objectObjectCursor.value;
                templatesAliases.put(aliasMetadata.alias(), aliasMetadata);
            }
        }
    }

    private List<IndexTemplateMetadata> findTemplates(CreatePartitionsRequest request, ClusterState state) {
        ArrayList<IndexTemplateMetadata> templates = new ArrayList<IndexTemplateMetadata>();
        String firstIndex = request.indices().iterator().next();
        block0: for (ObjectCursor cursor : state.metadata().templates().values()) {
            IndexTemplateMetadata template = (IndexTemplateMetadata)cursor.value;
            for (String pattern : template.getPatterns()) {
                if (!Regex.simpleMatch(pattern, firstIndex)) continue;
                templates.add(template);
                continue block0;
            }
        }
        CollectionUtil.timSort(templates, (o1, o2) -> o2.order() - o1.order());
        return templates;
    }

    private Map<String, Object> parseMapping(String mappingSource) throws Exception {
        Map<String, Object> map;
        block8: {
            XContentParser parser = XContentFactory.xContent(XContentType.JSON).createParser(this.xContentRegistry, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, mappingSource);
            try {
                map = parser.map();
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchException("failed to parse mapping", (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return map;
    }

    @Override
    protected ClusterBlockException checkBlock(CreatePartitionsRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, (String[])Iterables.toArray(request.indices(), String.class));
    }
}

