/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.create;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class CreatePartitionsRequest
extends AcknowledgedRequest<CreatePartitionsRequest> {
    private final Collection<String> indices;
    private final UUID jobId;

    public CreatePartitionsRequest(Collection<String> indices, UUID jobId) {
        this.indices = indices;
        this.jobId = jobId;
    }

    public Collection<String> indices() {
        return this.indices;
    }

    public UUID jobId() {
        return this.jobId;
    }

    public CreatePartitionsRequest(StreamInput in) throws IOException {
        super(in);
        this.jobId = new UUID(in.readLong(), in.readLong());
        int numIndices = in.readVInt();
        ArrayList<String> indicesList = new ArrayList<String>(numIndices);
        for (int i = 0; i < numIndices; ++i) {
            indicesList.add(in.readString());
        }
        this.indices = indicesList;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.jobId.getMostSignificantBits());
        out.writeLong(this.jobId.getLeastSignificantBits());
        out.writeVInt(this.indices.size());
        for (String index : this.indices) {
            out.writeString(index);
        }
    }
}

