/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.create;

import io.crate.common.collections.MapBuilder;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

public class CreateIndexRequest
extends AcknowledgedRequest<CreateIndexRequest>
implements IndicesRequest {
    public static final ParseField MAPPINGS = new ParseField("mappings", new String[0]);
    public static final ParseField SETTINGS = new ParseField("settings", new String[0]);
    public static final ParseField ALIASES = new ParseField("aliases", new String[0]);
    private String cause = "";
    private String index;
    private Settings settings = Settings.Builder.EMPTY_SETTINGS;
    private final Map<String, String> mappings = new HashMap<String, String>();
    private final Set<Alias> aliases = new HashSet<Alias>();
    private ActiveShardCount waitForActiveShards = ActiveShardCount.DEFAULT;

    public CreateIndexRequest() {
    }

    public CreateIndexRequest(String index) {
        this(index, Settings.Builder.EMPTY_SETTINGS);
    }

    public CreateIndexRequest(String index, Settings settings) {
        this.index = index;
        this.settings = settings;
    }

    @Override
    public String[] indices() {
        return new String[]{this.index};
    }

    @Override
    public IndicesOptions indicesOptions() {
        return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
    }

    public String index() {
        return this.index;
    }

    public CreateIndexRequest index(String index) {
        this.index = index;
        return this;
    }

    public Settings settings() {
        return this.settings;
    }

    public String cause() {
        return this.cause;
    }

    public CreateIndexRequest settings(Settings.Builder settings) {
        this.settings = settings.build();
        return this;
    }

    public CreateIndexRequest settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public CreateIndexRequest settings(String source, XContentType xContentType) {
        this.settings = Settings.builder().loadFromSource(source, xContentType).build();
        return this;
    }

    public CreateIndexRequest settings(XContentBuilder builder) {
        this.settings(Strings.toString(builder), builder.contentType());
        return this;
    }

    public CreateIndexRequest settings(Map source) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(source);
            this.settings(Strings.toString(builder), XContentType.JSON);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + source + "]", e);
        }
        return this;
    }

    public CreateIndexRequest mapping(String type, String source, XContentType xContentType) {
        return this.mapping(type, new BytesArray(source), xContentType);
    }

    private CreateIndexRequest mapping(String type, BytesReference source, XContentType xContentType) {
        if (this.mappings.containsKey(type)) {
            throw new IllegalStateException("mappings for type \"" + type + "\" were already defined");
        }
        Objects.requireNonNull(xContentType);
        try {
            this.mappings.put(type, XContentHelper.convertToJson(source, xContentType));
            return this;
        }
        catch (IOException e) {
            throw new UncheckedIOException("failed to convert to json", e);
        }
    }

    public CreateIndexRequest cause(String cause) {
        this.cause = cause;
        return this;
    }

    public CreateIndexRequest mapping(String type, XContentBuilder source) {
        return this.mapping(type, BytesReference.bytes(source), source.contentType());
    }

    public CreateIndexRequest mapping(String type, Map source) {
        if (this.mappings.containsKey(type)) {
            throw new IllegalStateException("mappings for type \"" + type + "\" were already defined");
        }
        if (source.size() != 1 || !source.containsKey(type)) {
            source = MapBuilder.newMapBuilder().put(type, source).map();
        }
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(source);
            return this.mapping(type, builder);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + source + "]", e);
        }
    }

    public CreateIndexRequest mapping(String type, Object ... source) {
        this.mapping(type, PutMappingRequest.buildFromSimplifiedDef(type, source));
        return this;
    }

    public CreateIndexRequest aliases(Map source) {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.map(source);
            return this.aliases(BytesReference.bytes(builder));
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + source + "]", e);
        }
    }

    public CreateIndexRequest aliases(XContentBuilder source) {
        return this.aliases(BytesReference.bytes(source));
    }

    public CreateIndexRequest aliases(String source) {
        return this.aliases(new BytesArray(source));
    }

    public CreateIndexRequest aliases(BytesReference source) {
        CreateIndexRequest createIndexRequest;
        block9: {
            XContentParser parser = XContentHelper.createParser(NamedXContentRegistry.EMPTY, LoggingDeprecationHandler.INSTANCE, source);
            try {
                parser.nextToken();
                while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                    this.alias(Alias.fromXContent(parser));
                }
                createIndexRequest = this;
                if (parser == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("Failed to parse aliases", (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return createIndexRequest;
    }

    public CreateIndexRequest alias(Alias alias) {
        this.aliases.add(alias);
        return this;
    }

    public CreateIndexRequest source(String source, XContentType xContentType) {
        return this.source(new BytesArray(source), xContentType);
    }

    public CreateIndexRequest source(XContentBuilder source) {
        return this.source(BytesReference.bytes(source), source.contentType());
    }

    public CreateIndexRequest source(byte[] source, XContentType xContentType) {
        return this.source(source, 0, source.length, xContentType);
    }

    public CreateIndexRequest source(byte[] source, int offset, int length, XContentType xContentType) {
        return this.source(new BytesArray(source, offset, length), xContentType);
    }

    public CreateIndexRequest source(BytesReference source, XContentType xContentType) {
        Objects.requireNonNull(xContentType);
        this.source(XContentHelper.convertToMap(source, false, xContentType).v2(), LoggingDeprecationHandler.INSTANCE);
        return this;
    }

    public CreateIndexRequest source(Map<String, ?> source, DeprecationHandler deprecationHandler) {
        boolean found = false;
        for (Map.Entry<String, ?> entry : source.entrySet()) {
            String name = entry.getKey();
            if (SETTINGS.match(name, deprecationHandler)) {
                found = true;
                this.settings((Map)entry.getValue());
                continue;
            }
            if (MAPPINGS.match(name, deprecationHandler)) {
                found = true;
                Map mappings = (Map)entry.getValue();
                for (Map.Entry entry1 : mappings.entrySet()) {
                    this.mapping((String)entry1.getKey(), (Map)entry1.getValue());
                }
                continue;
            }
            if (!ALIASES.match(name, deprecationHandler)) continue;
            found = true;
            this.aliases((Map)entry.getValue());
        }
        if (!found) {
            this.settings(source);
        }
        return this;
    }

    public Map<String, String> mappings() {
        return this.mappings;
    }

    public Set<Alias> aliases() {
        return this.aliases;
    }

    public ActiveShardCount waitForActiveShards() {
        return this.waitForActiveShards;
    }

    public CreateIndexRequest waitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.waitForActiveShards = waitForActiveShards;
        return this;
    }

    public CreateIndexRequest waitForActiveShards(int waitForActiveShards) {
        return this.waitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }

    public CreateIndexRequest(StreamInput in) throws IOException {
        super(in);
        this.cause = in.readString();
        this.index = in.readString();
        this.settings = Settings.readSettingsFromStream(in);
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            String type = in.readString();
            String source = in.readString();
            this.mappings.put(type, source);
        }
        int aliasesSize = in.readVInt();
        for (int i = 0; i < aliasesSize; ++i) {
            this.aliases.add(new Alias(in));
        }
        if (in.getVersion().before(Version.V_4_3_0)) {
            in.readBoolean();
        }
        this.waitForActiveShards = ActiveShardCount.readFrom(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.cause);
        out.writeString(this.index);
        Settings.writeSettingsToStream(this.settings, out);
        out.writeVInt(this.mappings.size());
        for (Map.Entry<String, String> entry : this.mappings.entrySet()) {
            out.writeString(entry.getKey());
            out.writeString(entry.getValue());
        }
        out.writeVInt(this.aliases.size());
        for (Alias alias : this.aliases) {
            alias.writeTo(out);
        }
        if (out.getVersion().before(Version.V_4_3_0)) {
            out.writeBoolean(true);
        }
        this.waitForActiveShards.writeTo(out);
    }
}

