/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.close;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.support.replication.ReplicationOperation;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportVerifyShardBeforeCloseAction
extends TransportReplicationAction<ShardRequest, ShardRequest, ReplicationResponse> {
    public static final String NAME = "indices:admin/close[s]";
    public static final ActionType<ReplicationResponse> TYPE = new ActionType("indices:admin/close[s]");

    @Inject
    public TransportVerifyShardBeforeCloseAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction stateAction) {
        super(NAME, transportService, clusterService, indicesService, threadPool, stateAction, ShardRequest::new, ShardRequest::new, "management");
    }

    @Override
    protected ReplicationResponse newResponseInstance(StreamInput in) throws IOException {
        return new ReplicationResponse(in);
    }

    @Override
    protected void acquirePrimaryOperationPermit(IndexShard primary, ShardRequest request, ActionListener<Releasable> onAcquired) {
        primary.acquireAllPrimaryOperationsPermits(onAcquired, request.timeout());
    }

    @Override
    protected void acquireReplicaOperationPermit(IndexShard replica, ShardRequest request, ActionListener<Releasable> onAcquired, long primaryTerm, long globalCheckpoint, long maxSeqNoOfUpdateOrDeletes) {
        replica.acquireAllReplicaOperationsPermits(primaryTerm, globalCheckpoint, maxSeqNoOfUpdateOrDeletes, onAcquired, request.timeout());
    }

    @Override
    public void shardOperationOnPrimary(ShardRequest shardRequest, IndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<ShardRequest, ReplicationResponse>> listener) {
        ActionListener.completeWith(listener, () -> {
            this.executeShardOperation(shardRequest, primary);
            return new TransportReplicationAction.PrimaryResult<ShardRequest, ReplicationResponse>(shardRequest, new ReplicationResponse());
        });
    }

    @Override
    protected TransportReplicationAction.ReplicaResult shardOperationOnReplica(ShardRequest shardRequest, IndexShard replica) throws IOException {
        this.executeShardOperation(shardRequest, replica);
        return new TransportReplicationAction.ReplicaResult();
    }

    private void executeShardOperation(ShardRequest request, IndexShard indexShard) throws IOException {
        ShardId shardId = indexShard.shardId();
        if (indexShard.getActiveOperationsCount() != -1) {
            throw new IllegalStateException("Index shard " + shardId + " is not blocking all operations during closing");
        }
        ClusterBlocks clusterBlocks = this.clusterService.state().blocks();
        if (!clusterBlocks.hasIndexBlock(shardId.getIndexName(), request.clusterBlock())) {
            throw new IllegalStateException("Index shard " + shardId + " must be blocked by " + request.clusterBlock() + " before closing");
        }
        if (request.isPhase1()) {
            indexShard.sync();
        } else {
            indexShard.verifyShardBeforeIndexClosing();
            indexShard.flush(new FlushRequest(new String[0]).force(true).waitIfOngoing(true));
            this.logger.trace("{} shard is ready for closing", (Object)shardId);
        }
    }

    @Override
    protected ReplicationOperation.Replicas<ShardRequest> newReplicasProxy() {
        return new VerifyShardBeforeCloseActionReplicasProxy();
    }

    public static class ShardRequest
    extends ReplicationRequest<ShardRequest> {
        private final ClusterBlock clusterBlock;
        private final boolean phase1;

        ShardRequest(StreamInput in) throws IOException {
            super(in);
            this.phase1 = in.readBoolean();
            this.clusterBlock = new ClusterBlock(in);
        }

        public ShardRequest(ShardId shardId, boolean phase1, ClusterBlock clusterBlock) {
            super(shardId);
            this.phase1 = phase1;
            this.clusterBlock = clusterBlock;
        }

        public ClusterBlock clusterBlock() {
            return this.clusterBlock;
        }

        public boolean isPhase1() {
            return this.phase1;
        }

        @Override
        public String toString() {
            return "verify shard " + this.shardId + " before close with block " + this.clusterBlock;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.phase1);
            this.clusterBlock.writeTo(out);
        }
    }

    class VerifyShardBeforeCloseActionReplicasProxy
    extends TransportReplicationAction.ReplicasProxy {
        VerifyShardBeforeCloseActionReplicasProxy() {
            super(TransportVerifyShardBeforeCloseAction.this);
        }

        @Override
        public void markShardCopyAsStaleIfNeeded(ShardId shardId, String allocationId, long primaryTerm, ActionListener<Void> listener) {
            TransportVerifyShardBeforeCloseAction.this.shardStateAction.remoteShardFailed(shardId, allocationId, primaryTerm, true, "mark copy as stale", null, listener);
        }
    }
}

