/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.alias;

import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

public class Alias
implements Writeable {
    private static final ParseField FILTER = new ParseField("filter", new String[0]);
    private static final ParseField ROUTING = new ParseField("routing", new String[0]);
    private static final ParseField INDEX_ROUTING = new ParseField("index_routing", "indexRouting", "index-routing");
    private static final ParseField SEARCH_ROUTING = new ParseField("search_routing", "searchRouting", "search-routing");
    private static final ParseField IS_WRITE_INDEX = new ParseField("is_write_index", new String[0]);
    private String name;
    @Nullable
    private String filter;
    @Nullable
    private String indexRouting;
    @Nullable
    private String searchRouting;
    @Nullable
    private Boolean writeIndex;

    private Alias() {
    }

    public Alias(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public String filter() {
        return this.filter;
    }

    public Alias filter(String filter) {
        this.filter = filter;
        return this;
    }

    public Alias filter(Map<String, Object> filter) {
        if (filter == null || filter.isEmpty()) {
            this.filter = null;
            return this;
        }
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(filter);
            this.filter = Strings.toString(builder);
            return this;
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + filter + "]", e);
        }
    }

    public Alias routing(String routing) {
        this.indexRouting = routing;
        this.searchRouting = routing;
        return this;
    }

    public String indexRouting() {
        return this.indexRouting;
    }

    public Alias indexRouting(String indexRouting) {
        this.indexRouting = indexRouting;
        return this;
    }

    public String searchRouting() {
        return this.searchRouting;
    }

    public Alias searchRouting(String searchRouting) {
        this.searchRouting = searchRouting;
        return this;
    }

    public Boolean writeIndex() {
        return this.writeIndex;
    }

    public Alias writeIndex(@Nullable Boolean writeIndex) {
        this.writeIndex = writeIndex;
        return this;
    }

    public Alias(StreamInput in) throws IOException {
        this.name = in.readString();
        this.filter = in.readOptionalString();
        this.indexRouting = in.readOptionalString();
        this.searchRouting = in.readOptionalString();
        this.writeIndex = in.readOptionalBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeOptionalString(this.filter);
        out.writeOptionalString(this.indexRouting);
        out.writeOptionalString(this.searchRouting);
        out.writeOptionalBoolean(this.writeIndex);
    }

    public static Alias fromXContent(XContentParser parser) throws IOException {
        Alias alias = new Alias(parser.currentName());
        String currentFieldName = null;
        XContentParser.Token token = parser.nextToken();
        if (token == null) {
            throw new IllegalArgumentException("No alias is specified");
        }
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (!FILTER.match(currentFieldName, parser.getDeprecationHandler())) continue;
                Map<String, Object> filter = parser.mapOrdered();
                alias.filter(filter);
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if (ROUTING.match(currentFieldName, parser.getDeprecationHandler())) {
                    alias.routing(parser.text());
                    continue;
                }
                if (INDEX_ROUTING.match(currentFieldName, parser.getDeprecationHandler())) {
                    alias.indexRouting(parser.text());
                    continue;
                }
                if (!SEARCH_ROUTING.match(currentFieldName, parser.getDeprecationHandler())) continue;
                alias.searchRouting(parser.text());
                continue;
            }
            if (token != XContentParser.Token.VALUE_BOOLEAN || !IS_WRITE_INDEX.match(currentFieldName, parser.getDeprecationHandler())) continue;
            alias.writeIndex(parser.booleanValue());
        }
        return alias;
    }

    public String toString() {
        return "Alias{name='" + this.name + "', filter='" + this.filter + "', indexRouting='" + this.indexRouting + "', searchRouting='" + this.searchRouting + "', writeIndex=" + this.writeIndex + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Alias alias = (Alias)o;
        return !(this.name != null ? !this.name.equals(alias.name) : alias.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }
}

