/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.get;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.transport.TransportResponse;

public class GetSnapshotsResponse
extends TransportResponse
implements ToXContentObject {
    private final List<SnapshotInfo> snapshots;

    public GetSnapshotsResponse(List<SnapshotInfo> snapshots) {
        this.snapshots = Collections.unmodifiableList(snapshots);
    }

    public List<SnapshotInfo> getSnapshots() {
        return this.snapshots;
    }

    public GetSnapshotsResponse(StreamInput in) throws IOException {
        int size = in.readVInt();
        ArrayList<SnapshotInfo> builder = new ArrayList<SnapshotInfo>(size);
        for (int i = 0; i < size; ++i) {
            builder.add(new SnapshotInfo(in));
        }
        this.snapshots = Collections.unmodifiableList(builder);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.snapshots.size());
        for (SnapshotInfo snapshotInfo : this.snapshots) {
            snapshotInfo.writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("snapshots");
        for (SnapshotInfo snapshotInfo : this.snapshots) {
            snapshotInfo.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetSnapshotsResponse that = (GetSnapshotsResponse)o;
        return Objects.equals(this.snapshots, that.snapshots);
    }

    public int hashCode() {
        return Objects.hash(this.snapshots);
    }
}

