/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.delete;

import java.io.IOException;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class DeleteSnapshotRequest
extends MasterNodeRequest<DeleteSnapshotRequest> {
    private String repository;
    private String snapshot;

    public DeleteSnapshotRequest() {
    }

    public DeleteSnapshotRequest(String repository, String snapshot) {
        this.repository = repository;
        this.snapshot = snapshot;
    }

    public DeleteSnapshotRequest(StreamInput in) throws IOException {
        super(in);
        this.repository = in.readString();
        this.snapshot = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.repository);
        out.writeString(this.snapshot);
    }

    public DeleteSnapshotRequest repository(String repository) {
        this.repository = repository;
        return this;
    }

    public String repository() {
        return this.repository;
    }

    public String snapshot() {
        return this.snapshot;
    }

    public DeleteSnapshotRequest snapshot(String snapshot) {
        this.snapshot = snapshot;
        return this;
    }
}

