/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.create;

import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.transport.TransportResponse;

public class CreateSnapshotResponse
extends TransportResponse
implements ToXContentObject {
    @Nullable
    private SnapshotInfo snapshotInfo;

    CreateSnapshotResponse(@Nullable SnapshotInfo snapshotInfo) {
        this.snapshotInfo = snapshotInfo;
    }

    CreateSnapshotResponse() {
    }

    public SnapshotInfo getSnapshotInfo() {
        return this.snapshotInfo;
    }

    public CreateSnapshotResponse(StreamInput in) throws IOException {
        this.snapshotInfo = in.readOptionalWriteable(SnapshotInfo::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.snapshotInfo);
    }

    public RestStatus status() {
        if (this.snapshotInfo == null) {
            return RestStatus.ACCEPTED;
        }
        return this.snapshotInfo.status();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.snapshotInfo != null) {
            builder.field("snapshot");
            this.snapshotInfo.toXContent(builder, params);
        } else {
            builder.field("accepted", true);
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        return "CreateSnapshotResponse{snapshotInfo=" + this.snapshotInfo + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateSnapshotResponse that = (CreateSnapshotResponse)o;
        return Objects.equals(this.snapshotInfo, that.snapshotInfo);
    }

    public int hashCode() {
        return Objects.hash(this.snapshotInfo);
    }
}

