/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.settings;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;

public class ClusterUpdateSettingsResponse
extends AcknowledgedResponse {
    private final Settings transientSettings;
    private final Settings persistentSettings;

    ClusterUpdateSettingsResponse(boolean acknowledged, Settings transientSettings, Settings persistentSettings) {
        super(acknowledged);
        this.persistentSettings = persistentSettings;
        this.transientSettings = transientSettings;
    }

    public ClusterUpdateSettingsResponse(StreamInput in) throws IOException {
        super(in);
        this.transientSettings = Settings.readSettingsFromStream(in);
        this.persistentSettings = Settings.readSettingsFromStream(in);
    }

    public Settings getTransientSettings() {
        return this.transientSettings;
    }

    public Settings getPersistentSettings() {
        return this.persistentSettings;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        Settings.writeSettingsToStream(this.transientSettings, out);
        Settings.writeSettingsToStream(this.persistentSettings, out);
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            ClusterUpdateSettingsResponse that = (ClusterUpdateSettingsResponse)o;
            return Objects.equals(this.transientSettings, that.transientSettings) && Objects.equals(this.persistentSettings, that.persistentSettings);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.transientSettings, this.persistentSettings);
    }
}

