/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.stats;

import java.io.IOException;
import javax.annotation.Nullable;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.monitor.fs.FsInfo;

public class NodeStats
extends BaseNodeResponse {
    private long timestamp;
    private FsInfo fs;

    public NodeStats(DiscoveryNode node, long timestamp, FsInfo fs) {
        super(node);
        this.timestamp = timestamp;
        this.fs = fs;
    }

    public NodeStats(StreamInput in) throws IOException {
        super(in);
        this.timestamp = in.readVLong();
        this.fs = in.readOptionalWriteable(FsInfo::new);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Nullable
    public String getHostname() {
        return this.getNode().getHostName();
    }

    public FsInfo getFs() {
        return this.fs;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVLong(this.timestamp);
        out.writeOptionalWriteable(this.fs);
    }
}

