/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.configuration;

import io.crate.common.unit.TimeValue;
import java.io.IOException;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.configuration.AddVotingConfigExclusionsRequest;
import org.elasticsearch.action.admin.cluster.configuration.AddVotingConfigExclusionsResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.coordination.CoordinationMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportAddVotingConfigExclusionsAction
extends TransportMasterNodeAction<AddVotingConfigExclusionsRequest, AddVotingConfigExclusionsResponse> {
    public static final Setting<Integer> MAXIMUM_VOTING_CONFIG_EXCLUSIONS_SETTING = Setting.intSetting("cluster.max_voting_config_exclusions", 10, 1, Setting.Property.Dynamic, Setting.Property.NodeScope);

    @Inject
    public TransportAddVotingConfigExclusionsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/voting_config/add_exclusions", transportService, clusterService, threadPool, AddVotingConfigExclusionsRequest::new, indexNameExpressionResolver);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected AddVotingConfigExclusionsResponse read(StreamInput in) throws IOException {
        return new AddVotingConfigExclusionsResponse(in);
    }

    @Override
    protected void masterOperation(Task task, final AddVotingConfigExclusionsRequest request, ClusterState state, final ActionListener<AddVotingConfigExclusionsResponse> listener) throws Exception {
        TransportAddVotingConfigExclusionsAction.resolveVotingConfigExclusionsAndCheckMaximum(request, state);
        this.clusterService.submitStateUpdateTask("add-voting-config-exclusions", new ClusterStateUpdateTask(Priority.URGENT){
            private Set<CoordinationMetadata.VotingConfigExclusion> resolvedExclusions;

            @Override
            public ClusterState execute(ClusterState currentState) {
                assert (this.resolvedExclusions == null) : this.resolvedExclusions;
                this.resolvedExclusions = TransportAddVotingConfigExclusionsAction.resolveVotingConfigExclusionsAndCheckMaximum(request, currentState);
                CoordinationMetadata.Builder builder = CoordinationMetadata.builder(currentState.coordinationMetadata());
                this.resolvedExclusions.forEach(builder::addVotingConfigExclusion);
                Metadata newMetadata = Metadata.builder(currentState.metadata()).coordinationMetadata(builder.build()).build();
                ClusterState newState = ClusterState.builder(currentState).metadata(newMetadata).build();
                assert (newState.getVotingConfigExclusions().size() <= MAXIMUM_VOTING_CONFIG_EXCLUSIONS_SETTING.get(currentState.metadata().settings()));
                return newState;
            }

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                ClusterStateObserver observer = new ClusterStateObserver(TransportAddVotingConfigExclusionsAction.this.clusterService, request.getTimeout(), TransportAddVotingConfigExclusionsAction.this.logger);
                Set excludedNodeIds = this.resolvedExclusions.stream().map(CoordinationMetadata.VotingConfigExclusion::getNodeId).collect(Collectors.toSet());
                Predicate<ClusterState> allNodesRemoved = clusterState -> {
                    Set<String> votingConfigNodeIds = clusterState.getLastCommittedConfiguration().getNodeIds();
                    return excludedNodeIds.stream().noneMatch(votingConfigNodeIds::contains);
                };
                ClusterStateObserver.Listener clusterStateListener = new ClusterStateObserver.Listener(){

                    @Override
                    public void onNewClusterState(ClusterState state) {
                        listener.onResponse(new AddVotingConfigExclusionsResponse());
                    }

                    @Override
                    public void onClusterServiceClose() {
                        listener.onFailure(new ElasticsearchException("cluster service closed while waiting for voting config exclusions " + resolvedExclusions + " to take effect", new Object[0]));
                    }

                    @Override
                    public void onTimeout(TimeValue timeout) {
                        listener.onFailure(new ElasticsearchTimeoutException("timed out waiting for voting config exclusions " + resolvedExclusions + " to take effect", new Object[0]));
                    }
                };
                if (allNodesRemoved.test(newState)) {
                    clusterStateListener.onNewClusterState(newState);
                } else {
                    observer.waitForNextChange(clusterStateListener, allNodesRemoved);
                }
            }
        });
    }

    private static Set<CoordinationMetadata.VotingConfigExclusion> resolveVotingConfigExclusionsAndCheckMaximum(AddVotingConfigExclusionsRequest request, ClusterState state) {
        return request.resolveVotingConfigExclusionsAndCheckMaximum(state, MAXIMUM_VOTING_CONFIG_EXCLUSIONS_SETTING.get(state.metadata().settings()), MAXIMUM_VOTING_CONFIG_EXCLUSIONS_SETTING.getKey());
    }

    @Override
    protected ClusterBlockException checkBlock(AddVotingConfigExclusionsRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

