/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.configuration;

import io.crate.common.unit.TimeValue;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.coordination.CoordinationMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class AddVotingConfigExclusionsRequest
extends MasterNodeRequest<AddVotingConfigExclusionsRequest> {
    private final String[] nodeDescriptions;
    private final TimeValue timeout;

    public AddVotingConfigExclusionsRequest(String[] nodeDescriptions) {
        this(nodeDescriptions, TimeValue.timeValueSeconds(30L));
    }

    public AddVotingConfigExclusionsRequest(String[] nodeDescriptions, TimeValue timeout) {
        if (timeout.compareTo(TimeValue.ZERO) < 0) {
            throw new IllegalArgumentException("timeout [" + timeout + "] must be non-negative");
        }
        this.nodeDescriptions = nodeDescriptions;
        this.timeout = timeout;
    }

    public AddVotingConfigExclusionsRequest(StreamInput in) throws IOException {
        super(in);
        this.nodeDescriptions = in.readStringArray();
        this.timeout = in.readTimeValue();
    }

    Set<CoordinationMetadata.VotingConfigExclusion> resolveVotingConfigExclusions(ClusterState currentState) {
        DiscoveryNodes allNodes = currentState.nodes();
        Set<CoordinationMetadata.VotingConfigExclusion> resolvedNodes = Arrays.stream(allNodes.resolveNodes(this.nodeDescriptions)).map(allNodes::get).filter(DiscoveryNode::isMasterNode).map(CoordinationMetadata.VotingConfigExclusion::new).collect(Collectors.toSet());
        if (resolvedNodes.isEmpty()) {
            throw new IllegalArgumentException("add voting config exclusions request for " + Arrays.asList(this.nodeDescriptions) + " matched no master-eligible nodes");
        }
        resolvedNodes.removeIf(n -> currentState.getVotingConfigExclusions().contains(n));
        return resolvedNodes;
    }

    Set<CoordinationMetadata.VotingConfigExclusion> resolveVotingConfigExclusionsAndCheckMaximum(ClusterState currentState, int maxExclusionsCount, String maximumSettingKey) {
        int newExclusionsCount;
        Set<CoordinationMetadata.VotingConfigExclusion> resolvedExclusions = this.resolveVotingConfigExclusions(currentState);
        int oldExclusionsCount = currentState.getVotingConfigExclusions().size();
        if (oldExclusionsCount + (newExclusionsCount = resolvedExclusions.size()) > maxExclusionsCount) {
            throw new IllegalArgumentException("add voting config exclusions request for " + Arrays.asList(this.nodeDescriptions) + " would add [" + newExclusionsCount + "] exclusions to the existing [" + oldExclusionsCount + "] which would exceed the maximum of [" + maxExclusionsCount + "] set by [" + maximumSettingKey + "]");
        }
        return resolvedExclusions;
    }

    public String[] getNodeDescriptions() {
        return this.nodeDescriptions;
    }

    public TimeValue getTimeout() {
        return this.timeout;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.nodeDescriptions);
        out.writeTimeValue(this.timeout);
    }

    public String toString() {
        return "AddVotingConfigExclusionsRequest{nodeDescriptions=" + Arrays.asList(this.nodeDescriptions) + ", timeout=" + this.timeout + "}";
    }
}

