/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.configuration.AddVotingConfigExclusionsAction;
import org.elasticsearch.action.admin.cluster.configuration.ClearVotingConfigExclusionsAction;
import org.elasticsearch.action.admin.cluster.configuration.TransportAddVotingConfigExclusionsAction;
import org.elasticsearch.action.admin.cluster.configuration.TransportClearVotingConfigExclusionsAction;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthAction;
import org.elasticsearch.action.admin.cluster.health.TransportClusterHealthAction;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsAction;
import org.elasticsearch.action.admin.cluster.node.stats.TransportNodesStatsAction;
import org.elasticsearch.action.admin.cluster.repositories.delete.DeleteRepositoryAction;
import org.elasticsearch.action.admin.cluster.repositories.delete.TransportDeleteRepositoryAction;
import org.elasticsearch.action.admin.cluster.repositories.put.PutRepositoryAction;
import org.elasticsearch.action.admin.cluster.repositories.put.TransportPutRepositoryAction;
import org.elasticsearch.action.admin.cluster.reroute.ClusterRerouteAction;
import org.elasticsearch.action.admin.cluster.reroute.TransportClusterRerouteAction;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsAction;
import org.elasticsearch.action.admin.cluster.settings.TransportClusterUpdateSettingsAction;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotAction;
import org.elasticsearch.action.admin.cluster.snapshots.create.TransportCreateSnapshotAction;
import org.elasticsearch.action.admin.cluster.snapshots.delete.DeleteSnapshotAction;
import org.elasticsearch.action.admin.cluster.snapshots.delete.TransportDeleteSnapshotAction;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsAction;
import org.elasticsearch.action.admin.cluster.snapshots.get.TransportGetSnapshotsAction;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotAction;
import org.elasticsearch.action.admin.cluster.snapshots.restore.TransportRestoreSnapshotAction;
import org.elasticsearch.action.admin.cluster.state.ClusterStateAction;
import org.elasticsearch.action.admin.cluster.state.TransportClusterStateAction;
import org.elasticsearch.action.admin.cluster.tasks.PendingClusterTasksAction;
import org.elasticsearch.action.admin.cluster.tasks.TransportPendingClusterTasksAction;
import org.elasticsearch.action.admin.indices.close.TransportVerifyShardBeforeCloseAction;
import org.elasticsearch.action.admin.indices.create.CreateIndexAction;
import org.elasticsearch.action.admin.indices.create.TransportCreateIndexAction;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexAction;
import org.elasticsearch.action.admin.indices.delete.TransportDeleteIndexAction;
import org.elasticsearch.action.admin.indices.flush.SyncedFlushAction;
import org.elasticsearch.action.admin.indices.flush.TransportShardFlushAction;
import org.elasticsearch.action.admin.indices.flush.TransportSyncedFlushAction;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeAction;
import org.elasticsearch.action.admin.indices.forcemerge.TransportForceMergeAction;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingAction;
import org.elasticsearch.action.admin.indices.mapping.put.TransportPutMappingAction;
import org.elasticsearch.action.admin.indices.recovery.RecoveryAction;
import org.elasticsearch.action.admin.indices.recovery.TransportRecoveryAction;
import org.elasticsearch.action.admin.indices.refresh.RefreshAction;
import org.elasticsearch.action.admin.indices.refresh.TransportRefreshAction;
import org.elasticsearch.action.admin.indices.refresh.TransportShardRefreshAction;
import org.elasticsearch.action.admin.indices.settings.put.TransportUpdateSettingsAction;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsAction;
import org.elasticsearch.action.admin.indices.shrink.ResizeAction;
import org.elasticsearch.action.admin.indices.shrink.TransportResizeAction;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsAction;
import org.elasticsearch.action.admin.indices.stats.TransportIndicesStatsAction;
import org.elasticsearch.action.admin.indices.template.delete.DeleteIndexTemplateAction;
import org.elasticsearch.action.admin.indices.template.delete.TransportDeleteIndexTemplateAction;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesAction;
import org.elasticsearch.action.admin.indices.template.get.TransportGetIndexTemplatesAction;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateAction;
import org.elasticsearch.action.admin.indices.template.put.TransportPutIndexTemplateAction;
import org.elasticsearch.action.admin.indices.upgrade.post.TransportUpgradeAction;
import org.elasticsearch.action.admin.indices.upgrade.post.TransportUpgradeSettingsAction;
import org.elasticsearch.action.admin.indices.upgrade.post.UpgradeAction;
import org.elasticsearch.action.admin.indices.upgrade.post.UpgradeSettingsAction;
import org.elasticsearch.action.support.DestructiveOperations;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.NamedRegistry;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.multibindings.MapBinder;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.gateway.TransportNodesListGatewayMetaState;
import org.elasticsearch.gateway.TransportNodesListGatewayStartedShards;
import org.elasticsearch.index.seqno.GlobalCheckpointSyncAction;
import org.elasticsearch.indices.store.TransportNodesListShardStoreMetadata;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;

public class ActionModule
extends AbstractModule {
    private final Map<String, ActionPlugin.ActionHandler<?, ?>> actions;
    private final DestructiveOperations destructiveOperations;

    public ActionModule(Settings settings, ClusterSettings clusterSettings, List<ActionPlugin> actionPlugins) {
        this.actions = ActionModule.setupActions(actionPlugins);
        this.destructiveOperations = new DestructiveOperations(settings, clusterSettings);
    }

    public Map<String, ActionPlugin.ActionHandler<?, ?>> getActions() {
        return this.actions;
    }

    static Map<String, ActionPlugin.ActionHandler<?, ?>> setupActions(List<ActionPlugin> actionPlugins) {
        class ActionRegistry
        extends NamedRegistry<ActionPlugin.ActionHandler<?, ?>> {
            ActionRegistry() {
                super("action");
            }

            public void register(ActionPlugin.ActionHandler<?, ?> handler) {
                this.register(handler.getAction().name(), handler);
            }

            public <Request extends TransportRequest, Response extends TransportResponse> void register(ActionType<Response> action, Class<? extends TransportAction<Request, Response>> transportAction, Class<?> ... supportTransportActions) {
                this.register(new ActionPlugin.ActionHandler(action, transportAction, supportTransportActions));
            }
        }
        ActionRegistry actions = new ActionRegistry();
        actions.register(ClusterStateAction.INSTANCE, TransportClusterStateAction.class, new Class[0]);
        actions.register(ClusterHealthAction.INSTANCE, TransportClusterHealthAction.class, new Class[0]);
        actions.register(ClusterUpdateSettingsAction.INSTANCE, TransportClusterUpdateSettingsAction.class, new Class[0]);
        actions.register(ClusterRerouteAction.INSTANCE, TransportClusterRerouteAction.class, new Class[0]);
        actions.register(PendingClusterTasksAction.INSTANCE, TransportPendingClusterTasksAction.class, new Class[0]);
        actions.register(PutRepositoryAction.INSTANCE, TransportPutRepositoryAction.class, new Class[0]);
        actions.register(DeleteRepositoryAction.INSTANCE, TransportDeleteRepositoryAction.class, new Class[0]);
        actions.register(GetSnapshotsAction.INSTANCE, TransportGetSnapshotsAction.class, new Class[0]);
        actions.register(DeleteSnapshotAction.INSTANCE, TransportDeleteSnapshotAction.class, new Class[0]);
        actions.register(CreateSnapshotAction.INSTANCE, TransportCreateSnapshotAction.class, new Class[0]);
        actions.register(RestoreSnapshotAction.INSTANCE, TransportRestoreSnapshotAction.class, new Class[0]);
        actions.register(IndicesStatsAction.INSTANCE, TransportIndicesStatsAction.class, new Class[0]);
        actions.register(CreateIndexAction.INSTANCE, TransportCreateIndexAction.class, new Class[0]);
        actions.register(ResizeAction.INSTANCE, TransportResizeAction.class, new Class[0]);
        actions.register(DeleteIndexAction.INSTANCE, TransportDeleteIndexAction.class, new Class[0]);
        actions.register(PutMappingAction.INSTANCE, TransportPutMappingAction.class, new Class[0]);
        actions.register(UpdateSettingsAction.INSTANCE, TransportUpdateSettingsAction.class, new Class[0]);
        actions.register(PutIndexTemplateAction.INSTANCE, TransportPutIndexTemplateAction.class, new Class[0]);
        actions.register(GetIndexTemplatesAction.INSTANCE, TransportGetIndexTemplatesAction.class, new Class[0]);
        actions.register(DeleteIndexTemplateAction.INSTANCE, TransportDeleteIndexTemplateAction.class, new Class[0]);
        actions.register(RefreshAction.INSTANCE, TransportRefreshAction.class, new Class[0]);
        actions.register(SyncedFlushAction.INSTANCE, TransportSyncedFlushAction.class, new Class[0]);
        actions.register(ForceMergeAction.INSTANCE, TransportForceMergeAction.class, new Class[0]);
        actions.register(UpgradeAction.INSTANCE, TransportUpgradeAction.class, new Class[0]);
        actions.register(UpgradeSettingsAction.INSTANCE, TransportUpgradeSettingsAction.class, new Class[0]);
        actions.register(RecoveryAction.INSTANCE, TransportRecoveryAction.class, new Class[0]);
        actions.register(AddVotingConfigExclusionsAction.INSTANCE, TransportAddVotingConfigExclusionsAction.class, new Class[0]);
        actions.register(ClearVotingConfigExclusionsAction.INSTANCE, TransportClearVotingConfigExclusionsAction.class, new Class[0]);
        actions.register(NodesStatsAction.INSTANCE, TransportNodesStatsAction.class, new Class[0]);
        actionPlugins.stream().flatMap(p -> p.getActions().stream()).forEach(actions::register);
        actions.register(GlobalCheckpointSyncAction.TYPE, GlobalCheckpointSyncAction.class, new Class[0]);
        actions.register(TransportNodesListGatewayMetaState.TYPE, TransportNodesListGatewayMetaState.class, new Class[0]);
        actions.register(TransportVerifyShardBeforeCloseAction.TYPE, TransportVerifyShardBeforeCloseAction.class, new Class[0]);
        actions.register(TransportNodesListGatewayStartedShards.TYPE, TransportNodesListGatewayStartedShards.class, new Class[0]);
        actions.register(TransportNodesListShardStoreMetadata.TYPE, TransportNodesListShardStoreMetadata.class, new Class[0]);
        actions.register(TransportShardFlushAction.TYPE, TransportShardFlushAction.class, new Class[0]);
        actions.register(TransportShardRefreshAction.TYPE, TransportShardRefreshAction.class, new Class[0]);
        return Collections.unmodifiableMap(actions.getRegistry());
    }

    @Override
    protected void configure() {
        this.bind(DestructiveOperations.class).toInstance(this.destructiveOperations);
        MapBinder<ActionType, TransportAction> transportActionsBinder = MapBinder.newMapBinder(this.binder(), ActionType.class, TransportAction.class);
        for (ActionPlugin.ActionHandler<?, ?> action : this.actions.values()) {
            this.bind(action.getTransportAction()).asEagerSingleton();
            transportActionsBinder.addBinding(action.getAction()).to(action.getTransportAction()).asEagerSingleton();
            for (Class<?> supportAction : action.getSupportTransportActions()) {
                this.bind(supportAction).asEagerSingleton();
            }
        }
    }
}

