/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import io.crate.common.CheckedFunction;
import io.crate.common.CheckedSupplier;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.NotifyOnceListener;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.CheckedRunnable;

public interface ActionListener<Response> {
    public void onResponse(Response var1);

    public void onFailure(Exception var1);

    public static <Response> ActionListener<Response> wrap(final CheckedConsumer<Response, ? extends Exception> onResponse, final Consumer<Exception> onFailure) {
        return new ActionListener<Response>(){

            @Override
            public void onResponse(Response response) {
                try {
                    onResponse.accept(response);
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Exception e) {
                onFailure.accept(e);
            }
        };
    }

    public static <T, R> ActionListener<T> delegateFailure(final ActionListener<R> delegate, final BiConsumer<ActionListener<R>, T> bc) {
        return new ActionListener<T>(){

            @Override
            public void onResponse(T r) {
                bc.accept(delegate, r);
            }

            @Override
            public void onFailure(Exception e) {
                delegate.onFailure(e);
            }
        };
    }

    public static <Response> ActionListener<Response> wrap(Runnable runnable) {
        return ActionListener.wrap(r -> runnable.run(), e -> runnable.run());
    }

    public static <Response> void onResponse(Iterable<ActionListener<Response>> listeners, Response response) {
        ArrayList<Exception> exceptionList = new ArrayList<Exception>();
        for (ActionListener<Response> listener : listeners) {
            try {
                listener.onResponse(response);
            }
            catch (Exception ex) {
                try {
                    listener.onFailure(ex);
                }
                catch (Exception ex1) {
                    exceptionList.add(ex1);
                }
            }
        }
        ExceptionsHelper.maybeThrowRuntimeAndSuppress(exceptionList);
    }

    public static <Response> void onFailure(Iterable<ActionListener<Response>> listeners, Exception failure) {
        ArrayList<Exception> exceptionList = new ArrayList<Exception>();
        for (ActionListener<Response> listener : listeners) {
            try {
                listener.onFailure(failure);
            }
            catch (Exception ex) {
                exceptionList.add(ex);
            }
        }
        ExceptionsHelper.maybeThrowRuntimeAndSuppress(exceptionList);
    }

    public static <T, Response> ActionListener<Response> map(ActionListener<T> listener, CheckedFunction<Response, T, Exception> fn) {
        return ActionListener.wrap(r -> listener.onResponse(fn.apply(r)), listener::onFailure);
    }

    public static <Response> BiConsumer<Response, Throwable> toBiConsumer(ActionListener<Response> listener) {
        return (response, throwable) -> {
            if (throwable == null) {
                listener.onResponse(response);
            } else if (throwable instanceof Exception) {
                listener.onFailure((Exception)throwable);
            } else {
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw new AssertionError("Should have been either Error or Exception", (Throwable)throwable);
            }
        };
    }

    public static <Response> ActionListener<Response> runAfter(final ActionListener<Response> delegate, final Runnable runAfter) {
        return new ActionListener<Response>(){

            @Override
            public void onResponse(Response response) {
                try {
                    delegate.onResponse(response);
                }
                finally {
                    runAfter.run();
                }
            }

            @Override
            public void onFailure(Exception e) {
                try {
                    delegate.onFailure(e);
                }
                finally {
                    runAfter.run();
                }
            }
        };
    }

    public static <Response> ActionListener<Response> notifyOnce(final ActionListener<Response> delegate) {
        return new NotifyOnceListener<Response>(){

            @Override
            protected void innerOnResponse(Response response) {
                delegate.onResponse(response);
            }

            @Override
            protected void innerOnFailure(Exception e) {
                delegate.onFailure(e);
            }
        };
    }

    public static <Response> void completeWith(ActionListener<Response> listener, CheckedSupplier<Response, ? extends Exception> supplier) {
        try {
            listener.onResponse(supplier.get());
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public static <Response> ActionListener<Response> runBefore(final ActionListener<Response> delegate, final CheckedRunnable<?> runBefore) {
        return new ActionListener<Response>(){

            @Override
            public void onResponse(Response response) {
                try {
                    runBefore.run();
                }
                catch (Exception ex) {
                    delegate.onFailure(ex);
                    return;
                }
                delegate.onResponse(response);
            }

            @Override
            public void onFailure(Exception e) {
                try {
                    runBefore.run();
                }
                catch (Exception ex) {
                    e.addSuppressed(ex);
                }
                delegate.onFailure(e);
            }
        };
    }

    public static <T> ActionListener<T> delegateResponse(final ActionListener<T> delegate, final BiConsumer<ActionListener<T>, Exception> onFailure) {
        return new ActionListener<T>(){

            @Override
            public void onResponse(T r) {
                delegate.onResponse(r);
            }

            @Override
            public void onFailure(Exception e) {
                onFailure.accept(delegate, e);
            }
        };
    }
}

