/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch;

import io.crate.common.SuppressForbidden;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.Assertions;
import org.elasticsearch.Build;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableOpenIntMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.monitor.jvm.JvmInfo;

public class Version
implements Comparable<Version>,
ToXContentFragment {
    private static final int V_EMPTY_ID = 0;
    public static final Version V_EMPTY = new Version(0, 0, false, org.apache.lucene.util.Version.LATEST);
    public static final Version V_3_0_1 = new Version(6010499, 3000199, false, org.apache.lucene.util.Version.LUCENE_7_1_0);
    public static final Version V_3_2_0 = new Version(6050199, 3020099, false, org.apache.lucene.util.Version.LUCENE_7_5_0);
    private static final int INTERNAL_OFFSET = 3000000;
    public static final Version V_4_0_0 = new Version(7000099, false, org.apache.lucene.util.Version.LUCENE_8_0_0);
    public static final Version V_4_0_1 = new Version(7000199, false, org.apache.lucene.util.Version.LUCENE_8_0_0);
    public static final Version V_4_0_2 = new Version(7000299, false, org.apache.lucene.util.Version.LUCENE_8_0_0);
    public static final Version V_4_0_3 = new Version(7000399, false, org.apache.lucene.util.Version.LUCENE_8_0_0);
    public static final Version V_4_0_4 = new Version(7000499, false, org.apache.lucene.util.Version.LUCENE_8_0_0);
    public static final Version V_4_0_5 = new Version(7000599, false, org.apache.lucene.util.Version.LUCENE_8_0_0);
    public static final Version V_4_0_6 = new Version(7000699, false, org.apache.lucene.util.Version.LUCENE_8_0_0);
    public static final Version V_4_0_7 = new Version(7000799, false, org.apache.lucene.util.Version.LUCENE_8_0_0);
    public static final Version V_4_0_8 = new Version(7000899, false, org.apache.lucene.util.Version.LUCENE_8_0_0);
    public static final Version V_4_0_9 = new Version(7000999, false, org.apache.lucene.util.Version.LUCENE_8_0_0);
    public static final Version V_4_0_10 = new Version(7001099, false, org.apache.lucene.util.Version.LUCENE_8_0_0);
    public static final Version V_4_0_11 = new Version(7001199, false, org.apache.lucene.util.Version.LUCENE_8_0_0);
    public static final Version V_4_0_12 = new Version(7001299, false, org.apache.lucene.util.Version.LUCENE_8_0_0);
    public static final Version V_4_1_0 = new Version(7010099, false, org.apache.lucene.util.Version.LUCENE_8_4_0);
    public static final Version V_4_1_1 = new Version(7010199, false, org.apache.lucene.util.Version.LUCENE_8_4_0);
    public static final Version V_4_1_2 = new Version(7010299, false, org.apache.lucene.util.Version.LUCENE_8_4_0);
    public static final Version V_4_1_3 = new Version(7010399, false, org.apache.lucene.util.Version.LUCENE_8_4_0);
    public static final Version V_4_1_4 = new Version(7010499, false, org.apache.lucene.util.Version.LUCENE_8_4_0);
    public static final Version V_4_1_5 = new Version(7010599, false, org.apache.lucene.util.Version.LUCENE_8_4_0);
    public static final Version V_4_1_6 = new Version(7010699, false, org.apache.lucene.util.Version.LUCENE_8_4_0);
    public static final Version V_4_1_7 = new Version(7010799, false, org.apache.lucene.util.Version.LUCENE_8_4_0);
    public static final Version V_4_1_8 = new Version(7010899, false, org.apache.lucene.util.Version.LUCENE_8_4_0);
    public static final Version V_4_2_0 = new Version(7020099, false, org.apache.lucene.util.Version.LUCENE_8_5_1);
    public static final Version V_4_2_1 = new Version(7020199, false, org.apache.lucene.util.Version.LUCENE_8_5_1);
    public static final Version V_4_2_2 = new Version(7020299, false, org.apache.lucene.util.Version.LUCENE_8_5_1);
    public static final Version V_4_2_3 = new Version(7020399, false, org.apache.lucene.util.Version.LUCENE_8_5_1);
    public static final Version V_4_2_4 = new Version(7020499, false, org.apache.lucene.util.Version.LUCENE_8_5_1);
    public static final Version V_4_2_5 = new Version(7020599, false, org.apache.lucene.util.Version.LUCENE_8_5_1);
    public static final Version V_4_2_6 = new Version(7020699, false, org.apache.lucene.util.Version.LUCENE_8_5_1);
    public static final Version V_4_2_7 = new Version(7020799, false, org.apache.lucene.util.Version.LUCENE_8_5_1);
    public static final Version V_4_3_0 = new Version(7030099, false, org.apache.lucene.util.Version.LUCENE_8_6_2);
    public static final Version V_4_3_1 = new Version(7030199, false, org.apache.lucene.util.Version.LUCENE_8_6_2);
    public static final Version V_4_3_2 = new Version(7030299, false, org.apache.lucene.util.Version.LUCENE_8_6_2);
    public static final Version V_4_3_3 = new Version(7030399, false, org.apache.lucene.util.Version.LUCENE_8_6_2);
    public static final Version V_4_3_4 = new Version(7030499, false, org.apache.lucene.util.Version.LUCENE_8_6_2);
    public static final Version V_4_4_0 = new Version(7040099, false, org.apache.lucene.util.Version.LUCENE_8_7_0);
    public static final Version V_4_4_1;
    public static final Version CURRENT;
    private static final ImmutableOpenIntMap<Version> ID_TO_VERSION;
    private final boolean isSnapshot;
    public final int externalId;
    public final int internalId;
    public final byte major;
    public final byte minor;
    public final byte revision;
    public final byte build;
    public final org.apache.lucene.util.Version luceneVersion;

    public static Version readVersion(StreamInput in) throws IOException {
        return Version.fromId(in.readVInt());
    }

    public static Version fromId(int id) {
        Version known = ID_TO_VERSION.get(id);
        if (known != null) {
            return known;
        }
        return Version.fromIdSlow(id);
    }

    private static Version fromIdSlow(int id) {
        org.apache.lucene.util.Version luceneVersion;
        List<Version> versions = DeclaredVersionsHolder.DECLARED_VERSIONS;
        Version tmp = new Version(id, false, org.apache.lucene.util.Version.LATEST);
        int index = Collections.binarySearch(versions, tmp);
        if (index < 0) {
            index = -2 - index;
        } else assert (false) : "Version [" + tmp + "] is declared but absent from the switch statement in Version#fromId";
        if (index == -1) {
            luceneVersion = org.apache.lucene.util.Version.fromBits((int)(versions.get((int)0).luceneVersion.major - 1), (int)0, (int)0);
        } else {
            Version closestVersion = versions.get(index);
            luceneVersion = closestVersion.major >= tmp.major ? closestVersion.luceneVersion : org.apache.lucene.util.Version.fromBits((int)(closestVersion.luceneVersion.major + 1), (int)0, (int)0);
        }
        return new Version(id, false, luceneVersion);
    }

    public static Version indexCreated(Settings indexSettings) {
        Version indexVersion = IndexMetadata.SETTING_INDEX_VERSION_CREATED.get(indexSettings);
        if (indexVersion == V_EMPTY) {
            String message = String.format(Locale.ROOT, "[%s] is not present in the index settings for index with UUID [%s]", IndexMetadata.SETTING_INDEX_VERSION_CREATED.getKey(), indexSettings.get("index.uuid"));
            throw new IllegalStateException(message);
        }
        return indexVersion;
    }

    public static void writeVersion(Version version, StreamOutput out) throws IOException {
        out.writeVInt(version.internalId);
    }

    public static Version min(Version version1, Version version2) {
        return version1.internalId < version2.internalId ? version1 : version2;
    }

    public static Version max(Version version1, Version version2) {
        return version1.internalId > version2.internalId ? version1 : version2;
    }

    public static Version fromInternalString(String version) {
        String[] parts;
        if (!Strings.hasLength(version)) {
            return CURRENT;
        }
        boolean snapshot = version.endsWith("-SNAPSHOT");
        if (snapshot) {
            version = version.substring(0, version.length() - 9);
        }
        if ((parts = version.split("[.-]")).length < 3 || parts.length > 4) {
            throw new IllegalArgumentException("the version needs to contain major, minor, and revision, and optionally the build: " + version);
        }
        try {
            int rawMajor = Integer.parseInt(parts[0]);
            if (rawMajor >= 5 && snapshot) {
                throw new IllegalArgumentException("illegal version format - snapshots are only supported until version 2.x");
            }
            int betaOffset = rawMajor < 5 ? 0 : 25;
            int major = rawMajor * 1000000;
            int minor = Integer.parseInt(parts[1]) * 10000;
            int revision = Integer.parseInt(parts[2]) * 100;
            int build = 99;
            if (parts.length == 4) {
                String buildStr = parts[3];
                if (buildStr.startsWith("alpha")) {
                    assert (rawMajor >= 5) : "major must be >= 5 but was " + major;
                    build = Integer.parseInt(buildStr.substring(5));
                    assert (build < 25) : "expected a beta build but " + build + " >= 25";
                } else if (buildStr.startsWith("Beta") || buildStr.startsWith("beta")) {
                    build = betaOffset + Integer.parseInt(buildStr.substring(4));
                    assert (build < 50) : "expected a beta build but " + build + " >= 50";
                } else if (buildStr.startsWith("RC") || buildStr.startsWith("rc")) {
                    build = Integer.parseInt(buildStr.substring(2)) + 50;
                } else {
                    throw new IllegalArgumentException("unable to parse version " + version);
                }
            }
            return Version.fromId(major + minor + revision + build);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("unable to parse version " + version, e);
        }
    }

    Version(int internalId, boolean isSnapshot, org.apache.lucene.util.Version luceneVersion) {
        this(internalId, internalId - 3000000, isSnapshot, luceneVersion);
    }

    Version(int internalId, int externalId, boolean isSnapshot, org.apache.lucene.util.Version luceneVersion) {
        this.internalId = internalId;
        this.externalId = externalId;
        this.major = (byte)(internalId / 1000000 % 100);
        this.minor = (byte)(internalId / 10000 % 100);
        this.revision = (byte)(internalId / 100 % 100);
        this.build = (byte)(internalId % 100);
        this.luceneVersion = luceneVersion;
        this.isSnapshot = isSnapshot;
    }

    public boolean isSnapshot() {
        return this.isSnapshot;
    }

    public boolean after(Version version) {
        return version.internalId < this.internalId;
    }

    public boolean afterMajorMinor(Version version) {
        if (version.major == this.major) {
            return version.minor < this.minor;
        }
        return version.major < this.major;
    }

    public boolean onOrAfter(Version version) {
        return version.internalId <= this.internalId;
    }

    public boolean before(Version version) {
        return version.internalId > this.internalId;
    }

    public boolean onOrBefore(Version version) {
        return version.internalId >= this.internalId;
    }

    @Override
    public int compareTo(Version other) {
        return Integer.compare(this.internalId, other.internalId);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.value(this.toString());
    }

    public Version minimumCompatibilityVersion() {
        return V_4_0_0;
    }

    public Version minimumIndexCompatibilityVersion() {
        return V_3_0_1;
    }

    public boolean isCompatible(Version version) {
        boolean compatible;
        boolean bl = compatible = this.onOrAfter(version.minimumCompatibilityVersion()) && version.onOrAfter(this.minimumCompatibilityVersion());
        assert (!compatible || Math.max(this.major, version.major) - Math.min(this.major, version.major) <= 1);
        return compatible;
    }

    @SuppressForbidden(reason="System.out.*")
    public static void main(String[] args) {
        String versionOutput = String.format(Locale.ROOT, "Version: %s, Build: %s/%s, JVM: %s", Version.displayVersion(CURRENT, CURRENT.isSnapshot()), Build.CURRENT.hashShort(), Build.CURRENT.timestamp(), JvmInfo.jvmInfo().version());
        System.out.println(versionOutput);
    }

    public String toString() {
        return this.externalNumber();
    }

    public String externalNumber() {
        return Integer.toString(this.externalId / 1000000 % 100) + "." + this.externalId / 10000 % 100 + "." + this.externalId / 100 % 100;
    }

    public static String displayVersion(Version version, boolean isSnapshot) {
        return version + (isSnapshot ? "-SNAPSHOT" : "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.internalId == version.internalId;
    }

    public int hashCode() {
        return this.internalId;
    }

    public boolean isRelease() {
        return this.build == 99;
    }

    public static List<Version> getDeclaredVersions(Class<?> versionClass) {
        Field[] fields = versionClass.getFields();
        ArrayList<Version> versions = new ArrayList<Version>(fields.length);
        block9: for (Field field : fields) {
            int mod = field.getModifiers();
            if (!Modifier.isStatic(mod) && Modifier.isFinal(mod) && Modifier.isPublic(mod) || field.getType() != Version.class) continue;
            switch (field.getName()) {
                case "CURRENT": 
                case "V_EMPTY": {
                    continue block9;
                }
                default: {
                    assert (field.getName().matches("(ES_)?V(_\\d+)+(_(alpha|beta|rc)\\d+)?")) : field.getName();
                    try {
                        versions.add((Version)field.get(null));
                        continue block9;
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        Collections.sort(versions);
        return versions;
    }

    static {
        CURRENT = V_4_4_1 = new Version(7040199, false, org.apache.lucene.util.Version.LUCENE_8_7_0);
        ImmutableOpenIntMap.Builder<Version> builder = ImmutableOpenIntMap.builder();
        for (Field declaredField : Version.class.getFields()) {
            String fieldName;
            if (!declaredField.getType().equals(Version.class) || (fieldName = declaredField.getName()).equals("CURRENT") || fieldName.equals("V_EMPTY")) continue;
            assert (fieldName.matches("V_\\d+_\\d+_\\d+")) : "expected Version field [" + fieldName + "] to match V_\\d+_\\d+_\\d+";
            try {
                Version version = (Version)declaredField.get(null);
                if (Assertions.ENABLED && version.major > 6) {
                    String[] fields = fieldName.split("_");
                    int major = Integer.valueOf(fields[1]) * 1000000;
                    int minor = Integer.valueOf(fields[2]) * 10000;
                    int revision = Integer.valueOf(fields[3]) * 100;
                    int expectedId = major + minor + revision + 99 + 3000000;
                    assert (version.internalId == expectedId) : "expected version [" + fieldName + "] to have id [" + expectedId + "] but was [" + version.internalId + "]";
                }
                Version maybePrevious = builder.put(version.internalId, version);
                if ($assertionsDisabled || maybePrevious == null) continue;
                throw new AssertionError((Object)("expected [" + version.internalId + "] to be uniquely mapped but saw [" + maybePrevious + "] and [" + version + "]"));
            }
            catch (IllegalAccessException e) {
                assert (false) : "Version field [" + fieldName + "] should be public";
            }
        }
        assert (Version.CURRENT.luceneVersion.equals((Object)org.apache.lucene.util.Version.LATEST)) : "Version must be upgraded to [" + org.apache.lucene.util.Version.LATEST + "] is still set to [" + Version.CURRENT.luceneVersion + "]";
        ID_TO_VERSION = builder.build();
    }

    private static class DeclaredVersionsHolder {
        static final List<Version> DECLARED_VERSIONS = Collections.unmodifiableList(Version.getDeclaredVersions(Version.class));

        private DeclaredVersionsHolder() {
        }
    }

    public static enum Property {
        CREATED,
        UPGRADED;

        private String nameLowerCase = this.name().toLowerCase(Locale.ENGLISH);

        public String toString() {
            return this.nameLowerCase;
        }
    }
}

