/*
 * Decompiled with CFR 0.152.
 */
package io.crate.user;

import io.crate.analyze.SymbolEvaluator;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.data.Row;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.sql.tree.GenericProperties;
import io.crate.types.DataTypes;
import io.crate.user.SecureHash;
import java.security.GeneralSecurityException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.elasticsearch.common.settings.SecureString;

public final class UserActions {
    private UserActions() {
    }

    @Nullable
    public static SecureHash generateSecureHash(GenericProperties<Symbol> userStmtProperties, Row parameters, TransactionContext txnCtx, NodeContext nodeCtx) throws GeneralSecurityException, IllegalArgumentException {
        try (SecureString pw = UserActions.getUserPasswordProperty(userStmtProperties, parameters, txnCtx, nodeCtx);){
            if (pw != null) {
                if (pw.length() == 0) {
                    throw new IllegalArgumentException("Password must not be empty");
                }
                SecureHash secureHash = SecureHash.of(pw);
                return secureHash;
            }
            SecureHash secureHash = null;
            return secureHash;
        }
    }

    @Nullable
    @VisibleForTesting
    static SecureString getUserPasswordProperty(GenericProperties<Symbol> userStmtProperties, Row parameters, TransactionContext txnCtx, NodeContext nodeCtx) throws IllegalArgumentException {
        Function<Symbol, Object> eval = x -> SymbolEvaluator.evaluate(txnCtx, nodeCtx, x, parameters, SubQueryResults.EMPTY);
        Map<String, Object> properties = userStmtProperties.map(eval).properties();
        String PASSWORD_PROPERTY = "password";
        Iterator<String> iterator = properties.keySet().iterator();
        if (iterator.hasNext()) {
            String key = iterator.next();
            if ("password".equals(key)) {
                String value = DataTypes.STRING.sanitizeValue(properties.get(key));
                if (value != null) {
                    return new SecureString(value.toCharArray());
                }
                return null;
            }
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "\"%s\" is not a valid user property", key));
        }
        return null;
    }
}

