/*
 * Decompiled with CFR 0.152.
 */
package io.crate.user;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Objects;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public final class SecureHash
implements Writeable,
ToXContent {
    private static final String X_CONTENT_KEY_ITERATIONS = "iterations";
    private static final String X_CONTENT_KEY_SALT = "salt";
    private static final String X_CONTENT_KEY_HASH = "hash";
    private static final String ALGORITHM = "PBKDF2WithHmacSHA512";
    private static final int HASH_BIT_LENGTH = 64;
    private static final int DEFAULT_ITERATIONS = 40000;
    private final int iterations;
    private final byte[] hash;
    private final byte[] salt;

    private SecureHash(byte[] salt, byte[] hash) {
        this(40000, salt, hash);
    }

    private SecureHash(int iterations, byte[] salt, byte[] hash) {
        this.iterations = iterations;
        this.salt = salt;
        this.hash = hash;
    }

    public static SecureHash of(SecureString password) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        byte[] salt = new byte[32];
        random.nextBytes(salt);
        byte[] hash = SecureHash.pbkdf2(password, salt, 40000, 64);
        return new SecureHash(salt, hash);
    }

    public static SecureHash of(int iterations, byte[] salt, byte[] hash) {
        return new SecureHash(iterations, salt, hash);
    }

    public boolean verifyHash(SecureString password) {
        try {
            byte[] testHash = SecureHash.pbkdf2(password, this.salt, this.iterations, 64);
            return SecureHash.slowEquals(this.hash, testHash);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            return false;
        }
    }

    private static boolean slowEquals(byte[] a, byte[] b) {
        int diff = a.length ^ b.length;
        for (int i = 0; i < a.length && i < b.length; ++i) {
            diff |= a[i] ^ b[i];
        }
        return diff == 0;
    }

    private static byte[] pbkdf2(SecureString password, byte[] salt, int iterations, int length) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PBEKeySpec spec = new PBEKeySpec(password.getChars(), salt, iterations, length * 8);
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(ALGORITHM);
        byte[] hash = secretKeyFactory.generateSecret(spec).getEncoded();
        spec.clearPassword();
        return hash;
    }

    public static SecureHash readFrom(StreamInput in) throws IOException {
        int iterations = in.readInt();
        byte[] hash = in.readByteArray();
        byte[] salt = in.readByteArray();
        return new SecureHash(iterations, salt, hash);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeInt(this.iterations);
        out.writeByteArray(this.hash);
        out.writeByteArray(this.salt);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("secure_hash").field(X_CONTENT_KEY_ITERATIONS, this.iterations).field(X_CONTENT_KEY_HASH, this.hash).field(X_CONTENT_KEY_SALT, this.salt).endObject();
        return builder;
    }

    public static SecureHash fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token currentToken;
        int iterations = 0;
        byte[] hash = new byte[]{};
        byte[] salt = new byte[]{};
        boolean hasPassword = false;
        while ((currentToken = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (currentToken != XContentParser.Token.FIELD_NAME) continue;
            block11: while ((currentToken = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                hasPassword = true;
                if (currentToken != XContentParser.Token.FIELD_NAME) continue;
                String currentFieldName = parser.currentName();
                currentToken = parser.nextToken();
                switch (currentFieldName) {
                    case "iterations": {
                        if (currentToken != XContentParser.Token.VALUE_NUMBER) {
                            throw new ElasticsearchParseException("failed to parse SecureHash, 'iterations' value is not a number [{}]", new Object[]{currentToken});
                        }
                        iterations = parser.intValue();
                        continue block11;
                    }
                    case "hash": {
                        if (!currentToken.isValue()) {
                            throw new ElasticsearchParseException("failed to parse SecureHash, 'hash' does not contain any value [{}]", new Object[]{currentToken});
                        }
                        hash = parser.binaryValue();
                        continue block11;
                    }
                    case "salt": {
                        if (!currentToken.isValue()) {
                            throw new ElasticsearchParseException("failed to parse SecureHash, 'salt' does not contain any value [{}]", new Object[]{currentToken});
                        }
                        salt = parser.binaryValue();
                        continue block11;
                    }
                }
                throw new ElasticsearchParseException("failed to parse secure_hash", new Object[0]);
            }
        }
        if (hasPassword) {
            return SecureHash.of(iterations, salt, hash);
        }
        return null;
    }

    public int hashCode() {
        return Objects.hash(this.iterations, this.salt, this.hash);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecureHash that = (SecureHash)o;
        if (this.iterations != that.iterations) {
            return false;
        }
        if (!Arrays.equals(this.hash, that.hash)) {
            return false;
        }
        return Arrays.equals(this.salt, that.salt);
    }
}

