/*
 * Decompiled with CFR 0.152.
 */
package io.crate.udc.service;

import io.crate.common.unit.TimeValue;
import io.crate.license.LicenseService;
import io.crate.monitor.ExtendedNodeInfo;
import io.crate.settings.CrateSetting;
import io.crate.types.DataTypes;
import io.crate.udc.ping.PingTask;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public class UDCService
extends AbstractLifecycleComponent {
    private static final Logger LOGGER = LogManager.getLogger(UDCService.class);
    public static final CrateSetting<Boolean> UDC_ENABLED_SETTING = CrateSetting.of(Setting.boolSetting("udc.enabled", true, Setting.Property.NodeScope), DataTypes.BOOLEAN);
    public static final CrateSetting<String> UDC_URL_SETTING = CrateSetting.of(new Setting("udc.url", "https://udc.crate.io/", Function.identity(), Setting.Property.NodeScope), DataTypes.STRING);
    public static final CrateSetting<TimeValue> UDC_INITIAL_DELAY_SETTING = CrateSetting.of(Setting.positiveTimeSetting("udc.initial_delay", new TimeValue(10L, TimeUnit.MINUTES), Setting.Property.NodeScope), DataTypes.STRING);
    public static final CrateSetting<TimeValue> UDC_INTERVAL_SETTING = CrateSetting.of(Setting.positiveTimeSetting("udc.interval", new TimeValue(24L, TimeUnit.HOURS), Setting.Property.NodeScope), DataTypes.STRING);
    private final Timer timer;
    private final ClusterService clusterService;
    private final ExtendedNodeInfo extendedNodeInfo;
    private final LicenseService licenseService;
    private final Settings settings;

    @Inject
    public UDCService(Settings settings, ExtendedNodeInfo extendedNodeInfo, ClusterService clusterService, LicenseService licenseService) {
        this.settings = settings;
        this.extendedNodeInfo = extendedNodeInfo;
        this.clusterService = clusterService;
        this.licenseService = licenseService;
        this.timer = new Timer("crate-udc");
    }

    @Override
    protected void doStart() throws ElasticsearchException {
        String url = UDC_URL_SETTING.setting().get(this.settings);
        TimeValue initialDelay = UDC_INITIAL_DELAY_SETTING.setting().get(this.settings);
        TimeValue interval = UDC_INTERVAL_SETTING.setting().get(this.settings);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Starting with delay {} and period {}.", (Object)initialDelay.getSeconds(), (Object)interval.getSeconds());
        }
        PingTask pingTask = new PingTask(this.clusterService, this.extendedNodeInfo, url, this.licenseService);
        this.timer.scheduleAtFixedRate((TimerTask)pingTask, initialDelay.millis(), interval.millis());
    }

    @Override
    protected void doStop() throws ElasticsearchException {
        this.timer.cancel();
    }

    @Override
    protected void doClose() throws ElasticsearchException {
        this.timer.cancel();
    }
}

