/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.Streamer;
import io.crate.common.collections.MapComparator;
import io.crate.types.DataType;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class UncheckedObjectType
extends DataType<Map<Object, Object>>
implements Streamer<Map<Object, Object>> {
    public static final UncheckedObjectType INSTANCE = new UncheckedObjectType();
    public static final int ID = 16;
    public static final String NAME = "unchecked_object";

    public static UncheckedObjectType untyped() {
        return new UncheckedObjectType();
    }

    UncheckedObjectType() {
    }

    @Override
    public int id() {
        return 16;
    }

    @Override
    public DataType.Precedence precedence() {
        return DataType.Precedence.UNCHECKED_OBJECT;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Streamer<Map<Object, Object>> streamer() {
        return this;
    }

    @Override
    public Map<Object, Object> implicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        return (Map)value;
    }

    @Override
    public Map<Object, Object> sanitizeValue(Object value) {
        return (Map)value;
    }

    @Override
    public int compare(Map<Object, Object> val1, Map<Object, Object> val2) {
        return MapComparator.compareMaps(val1, val2);
    }

    @Override
    public Map<Object, Object> readValueFrom(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            int size = in.readInt();
            HashMap<Object, Object> m = new HashMap<Object, Object>(size);
            for (int i = 0; i < size; ++i) {
                Object key = in.readGenericValue();
                Object val = in.readGenericValue();
                m.put(key, val);
            }
            return m;
        }
        return null;
    }

    @Override
    public void writeValueTo(StreamOutput out, Map<Object, Object> v) throws IOException {
        if (v == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeInt(v.size());
            for (Map.Entry<Object, Object> entry : v.entrySet()) {
                out.writeGenericValue(entry.getKey());
                out.writeGenericValue(entry.getValue());
            }
        }
    }
}

