/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.IntegerLiteralTypeSignature;
import io.crate.types.ObjectType;
import io.crate.types.ParameterTypeSignature;
import io.crate.types.RowType;
import io.crate.types.TypeSignatureType;
import io.crate.types.UndefinedType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class TypeSignature
implements Writeable {
    private final String baseTypeName;
    private final List<TypeSignature> parameters;

    public static TypeSignature parseTypeSignature(String signature) {
        if (Character.isDigit(signature.charAt(0)) && !signature.contains(" ")) {
            return TypeSignature.of(Integer.parseInt(signature));
        }
        if (!signature.contains("(")) {
            return TypeSignature.of(signature, List.of());
        }
        String baseName = null;
        ArrayList<TypeSignature> parameters = new ArrayList<TypeSignature>();
        int parameterStart = -1;
        int bracketCount = 0;
        for (int i = 0; i < signature.length(); ++i) {
            char c = signature.charAt(i);
            if (c == '(') {
                if (bracketCount == 0) {
                    assert (baseName == null) : "Expected baseName to be null";
                    baseName = signature.substring(0, i);
                    parameterStart = i + 1;
                }
                ++bracketCount;
                continue;
            }
            if (c == ')') {
                if (--bracketCount != 0) continue;
                assert (parameterStart >= 0) : "Expected parameter start to be >= 0";
                parameters.add(TypeSignature.parseTypeSignatureParameter(signature, parameterStart, i));
                parameterStart = i + 1;
                if (i != signature.length() - 1) continue;
                return TypeSignature.of(baseName, parameters);
            }
            if (c != ',' || bracketCount != 1) continue;
            assert (parameterStart >= 0) : "Expected parameter start to be >= 0";
            parameters.add(TypeSignature.parseTypeSignatureParameter(signature, parameterStart, i));
            parameterStart = i + 1;
        }
        throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Bad type signature: '%s'", signature));
    }

    protected static TypeSignature of(int parseInt) {
        return new IntegerLiteralTypeSignature(parseInt);
    }

    private static TypeSignature of(String signature, List<TypeSignature> parameters) {
        if (TypeSignature.isNamedTypeSignature(signature)) {
            int split = signature.indexOf(" ");
            return new ParameterTypeSignature(signature.substring(0, split), new TypeSignature(signature.substring(split + 1), parameters));
        }
        return new TypeSignature(signature, parameters);
    }

    private static boolean isNamedTypeSignature(String signature) {
        return !DataTypes.PRIMITIVE_TYPE_NAMES_WITH_SPACES.contains(signature) && signature.contains(" ");
    }

    private static TypeSignature parseTypeSignatureParameter(String signature, int begin, int end) {
        String parameterName = signature.substring(begin, end).trim();
        return TypeSignature.parseTypeSignature(parameterName);
    }

    public static void toStream(TypeSignature typeSignature, StreamOutput out) throws IOException {
        out.writeVInt(typeSignature.type().ordinal());
        typeSignature.writeTo(out);
    }

    public static TypeSignature fromStream(StreamInput in) throws IOException {
        return TypeSignatureType.VALUES.get(in.readVInt()).newInstance(in);
    }

    public TypeSignature(String baseTypeName) {
        this(baseTypeName, Collections.emptyList());
    }

    public TypeSignature(String baseTypeName, List<TypeSignature> parameters) {
        this.baseTypeName = baseTypeName;
        this.parameters = parameters;
    }

    public TypeSignature(StreamInput in) throws IOException {
        this.baseTypeName = in.readString();
        int numParams = in.readVInt();
        this.parameters = new ArrayList<TypeSignature>(numParams);
        for (int i = 0; i < numParams; ++i) {
            this.parameters.add(TypeSignature.fromStream(in));
        }
    }

    public String getBaseTypeName() {
        return this.baseTypeName;
    }

    public List<TypeSignature> getParameters() {
        return this.parameters;
    }

    public DataType<?> createType() {
        if (this.baseTypeName.equalsIgnoreCase("array")) {
            if (this.parameters.size() == 0) {
                return new ArrayType<Object>(UndefinedType.INSTANCE);
            }
            DataType<?> innerType = this.parameters.get(0).createType();
            return new ArrayType(innerType);
        }
        if (this.baseTypeName.equalsIgnoreCase("object")) {
            ObjectType.Builder builder = ObjectType.builder();
            if (this.parameters.size() > 1) {
                for (int i = 0; i < this.parameters.size() - 1; i += 2) {
                    TypeSignature valTypeSignature = this.parameters.get(i + 1);
                    if (!(valTypeSignature instanceof ParameterTypeSignature)) continue;
                    String innerTypeName = ((ParameterTypeSignature)valTypeSignature).parameterName();
                    builder.setInnerType(innerTypeName, valTypeSignature.createType());
                }
            }
            return builder.build();
        }
        if (this.baseTypeName.equalsIgnoreCase("record")) {
            ArrayList<String> fields = new ArrayList<String>(this.parameters.size());
            ArrayList dataTypes = new ArrayList(this.parameters.size());
            for (int i = 0; i < this.parameters.size(); ++i) {
                TypeSignature parameterTypeSignature = this.parameters.get(i);
                if (!(parameterTypeSignature instanceof ParameterTypeSignature)) {
                    return RowType.EMPTY;
                }
                fields.add(((ParameterTypeSignature)parameterTypeSignature).parameterName());
                dataTypes.add(parameterTypeSignature.createType());
            }
            return new RowType(dataTypes, fields);
        }
        ArrayList<Integer> integerLiteralParameters = new ArrayList<Integer>(this.parameters.size());
        for (TypeSignature parameter : this.parameters) {
            if (!parameter.type().equals((Object)TypeSignatureType.INTEGER_LITERAL_SIGNATURE)) {
                throw new IllegalArgumentException("The signature type of the based data type parameters can only be: " + TypeSignatureType.INTEGER_LITERAL_SIGNATURE.toString());
            }
            integerLiteralParameters.add(((IntegerLiteralTypeSignature)parameter).value());
        }
        return DataTypes.of(this.baseTypeName, integerLiteralParameters);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.baseTypeName);
        out.writeVInt(this.parameters.size());
        for (TypeSignature parameter : this.parameters) {
            TypeSignature.toStream(parameter, out);
        }
    }

    public String toString() {
        if (this.parameters.isEmpty()) {
            return this.baseTypeName;
        }
        StringBuilder typeName = new StringBuilder(this.baseTypeName);
        typeName.append("(").append(this.parameters.get(0));
        for (int i = 1; i < this.parameters.size(); ++i) {
            typeName.append(",").append(this.parameters.get(i));
        }
        typeName.append(")");
        return typeName.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() && this.getClass() != ParameterTypeSignature.class) {
            return false;
        }
        TypeSignature that = (TypeSignature)o;
        return this.equalsIgnoringObjectParameterSizeDifference(that);
    }

    private boolean equalsIgnoringObjectParameterSizeDifference(TypeSignature that) {
        if (this.baseTypeName.equals("object") && that.baseTypeName.equals("object") && this.parameters.size() != that.parameters.size()) {
            return true;
        }
        return this.baseTypeName.equals(that.baseTypeName) && this.parameters.equals(that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.baseTypeName, this.parameters);
    }

    public TypeSignatureType type() {
        return TypeSignatureType.TYPE_SIGNATURE;
    }
}

