/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.types.DataType;
import io.crate.types.StringType;
import io.crate.types.TypeSignature;
import io.crate.types.UndefinedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public final class TypeCompatibility {
    @Nullable
    public static DataType<?> getCommonType(DataType<?> firstType, DataType<?> secondType) {
        return TypeCompatibility.compatibility(firstType, secondType);
    }

    @Nullable
    private static DataType<?> compatibility(DataType<?> fromType, DataType<?> toType) {
        String toTypeBaseName;
        if (fromType.equals(toType)) {
            return toType;
        }
        if (fromType.equals(UndefinedType.INSTANCE)) {
            return toType;
        }
        if (toType.equals(UndefinedType.INSTANCE)) {
            return fromType;
        }
        String fromTypeBaseName = fromType.getTypeSignature().getBaseTypeName();
        if (fromTypeBaseName.equals(toTypeBaseName = toType.getTypeSignature().getBaseTypeName())) {
            if (!fromType.getTypeParameters().isEmpty() || !toType.getTypeParameters().isEmpty()) {
                return TypeCompatibility.typeCompatibilityForParametrizedType(fromType, toType);
            }
            return fromType;
        }
        return TypeCompatibility.convertTypeByPrecedence(fromType, toType);
    }

    @Nullable
    private static DataType<?> convertTypeByPrecedence(DataType<?> arg1, DataType<?> arg2) {
        DataType<?> lowerPrecedenceArg;
        DataType<?> higherPrecedenceArg;
        if (arg1.precedes(arg2)) {
            higherPrecedenceArg = arg1;
            lowerPrecedenceArg = arg2;
        } else {
            higherPrecedenceArg = arg2;
            lowerPrecedenceArg = arg1;
        }
        boolean lowerPrecedenceCastable = lowerPrecedenceArg.isConvertableTo(higherPrecedenceArg, false);
        boolean higherPrecedenceCastable = higherPrecedenceArg.isConvertableTo(lowerPrecedenceArg, false);
        if (lowerPrecedenceCastable) {
            return higherPrecedenceArg;
        }
        if (higherPrecedenceCastable) {
            return lowerPrecedenceArg;
        }
        return null;
    }

    @Nullable
    private static DataType<?> typeCompatibilityForParametrizedType(DataType<?> fromType, DataType<?> toType) {
        ArrayList<TypeSignature> commonParameterTypes = new ArrayList<TypeSignature>();
        List<DataType<?>> fromTypeParameters = fromType.getTypeParameters();
        List<DataType<?>> toTypeParameters = toType.getTypeParameters();
        if (fromTypeParameters.size() != toTypeParameters.size()) {
            if (fromType.id() == 12 && toType.id() == 12) {
                return fromTypeParameters.size() > toTypeParameters.size() ? fromType : toType;
            }
            if (fromType.id() == 4 && toType.id() == 4 && (((StringType)fromType).unbound() || ((StringType)toType).unbound())) {
                return StringType.INSTANCE;
            }
            return null;
        }
        if (fromType.id() == 4 && toType.id() == 4) {
            if (((StringType)fromType).lengthLimit() > ((StringType)toType).lengthLimit()) {
                return fromType;
            }
            return toType;
        }
        for (int i = 0; i < fromTypeParameters.size(); ++i) {
            DataType<?> compatibility = TypeCompatibility.compatibility(fromTypeParameters.get(i), toTypeParameters.get(i));
            if (compatibility == null) {
                return null;
            }
            commonParameterTypes.add(compatibility.getTypeSignature());
        }
        String typeBase = fromType.getTypeSignature().getBaseTypeName();
        return new TypeSignature(typeBase, Collections.unmodifiableList(commonParameterTypes)).createType();
    }
}

