/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.Streamer;
import io.crate.types.DataType;
import io.crate.types.FixedWidthType;
import io.crate.types.LongType;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.function.Function;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public final class TimestampType
extends DataType<Long>
implements FixedWidthType,
Streamer<Long> {
    public static final int ID_WITH_TZ = 11;
    public static final int ID_WITHOUT_TZ = 15;
    public static final TimestampType INSTANCE_WITH_TZ = new TimestampType(11, "timestamp with time zone", TimestampType::parseTimestamp, DataType.Precedence.TIMESTAMP_WITH_TIME_ZONE);
    public static final TimestampType INSTANCE_WITHOUT_TZ = new TimestampType(15, "timestamp without time zone", TimestampType::parseTimestampIgnoreTimeZone, DataType.Precedence.TIMESTAMP);
    private final int id;
    private final String name;
    private final Function<String, Long> parse;
    private final DataType.Precedence precedence;
    private static final DateTimeFormatter TIMESTAMP_PARSER = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().padNext(1).optionalStart().appendLiteral('T').optionalEnd().append(DateTimeFormatter.ISO_LOCAL_TIME).optionalStart().appendPattern("[Z][VV][x][xx][xxx]").toFormatter(Locale.ENGLISH).withResolverStyle(ResolverStyle.STRICT);

    private TimestampType(int id, String name, Function<String, Long> parse, DataType.Precedence precedence) {
        this.id = id;
        this.name = name;
        this.parse = parse;
        this.precedence = precedence;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DataType.Precedence precedence() {
        return this.precedence;
    }

    @Override
    public Streamer<Long> streamer() {
        return this;
    }

    @Override
    public Long implicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            return this.parse.apply((String)value);
        }
        if (value instanceof Double) {
            return ((Number)((Double)value * 1000.0)).longValue();
        }
        if (value instanceof Float) {
            return ((Number)Float.valueOf(((Float)value).floatValue() * 1000.0f)).longValue();
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        throw new ClassCastException("Can't cast '" + value + "' to " + this.getName());
    }

    @Override
    public Long sanitizeValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        return ((Number)value).longValue();
    }

    @Override
    public int compare(Long val1, Long val2) {
        return Long.compare(val1, val2);
    }

    @Override
    public Long readValueFrom(StreamInput in) throws IOException {
        return in.readBoolean() ? null : Long.valueOf(in.readLong());
    }

    @Override
    public void writeValueTo(StreamOutput out, Long v) throws IOException {
        out.writeBoolean(v == null);
        if (v != null) {
            out.writeLong(v);
        }
    }

    @Override
    public int fixedSize() {
        return LongType.LONG_SIZE;
    }

    static long parseTimestamp(String timestamp) {
        try {
            return Long.parseLong(timestamp);
        }
        catch (NumberFormatException e) {
            TemporalAccessor dt;
            try {
                dt = TIMESTAMP_PARSER.parseBest(timestamp, OffsetDateTime::from, LocalDateTime::from, LocalDate::from);
            }
            catch (DateTimeParseException e1) {
                throw new IllegalArgumentException(e1.getMessage());
            }
            if (dt instanceof LocalDateTime) {
                LocalDateTime localDateTime = LocalDateTime.from(dt);
                return localDateTime.toInstant(ZoneOffset.UTC).toEpochMilli();
            }
            if (dt instanceof LocalDate) {
                LocalDate localDate = LocalDate.from(dt);
                return localDate.atStartOfDay(ZoneOffset.UTC).toInstant().toEpochMilli();
            }
            OffsetDateTime offsetDateTime = OffsetDateTime.from(dt);
            return offsetDateTime.toInstant().toEpochMilli();
        }
    }

    static long parseTimestampIgnoreTimeZone(String timestamp) {
        try {
            return Long.parseLong(timestamp);
        }
        catch (NumberFormatException e) {
            TemporalAccessor dt;
            try {
                dt = TIMESTAMP_PARSER.parseBest(timestamp, LocalDateTime::from, LocalDate::from);
            }
            catch (DateTimeParseException e1) {
                throw new IllegalArgumentException(e1.getMessage());
            }
            if (dt instanceof LocalDate) {
                LocalDate localDate = LocalDate.from(dt);
                return localDate.atStartOfDay(ZoneOffset.UTC).toInstant().toEpochMilli();
            }
            LocalDateTime localDateTime = LocalDateTime.from(dt);
            return localDateTime.toInstant(ZoneOffset.UTC).toEpochMilli();
        }
    }
}

