/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.types.TimeTZ;
import io.crate.types.TimeTZType;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Locale;
import javax.annotation.Nonnull;

public final class TimeTZParser {
    private static final long MAX_MICROS = 86399999999L;
    private static final DateTimeFormatter TIMETZ_PARSER = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.HOUR_OF_DAY, 2).optionalStart().optionalStart().appendLiteral(':').optionalEnd().appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().optionalStart().appendLiteral(':').optionalEnd().appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalEnd().optionalEnd().optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).optionalEnd().optionalStart().appendPattern("[Z][VV][x][xx][xxx]").optionalEnd().toFormatter(Locale.ENGLISH).withResolverStyle(ResolverStyle.STRICT);

    public static TimeTZ timeTZOf(String source, long value) {
        return new TimeTZ(TimeTZParser.checkRange(source, value, 86399999999L), 0);
    }

    public static TimeTZ parse(@Nonnull String format) {
        try {
            TemporalAccessor dt = TIMETZ_PARSER.parse(format.replaceAll("\\s+", ""));
            int hh = TimeTZParser.access(dt, ChronoField.HOUR_OF_DAY);
            int mm = TimeTZParser.access(dt, ChronoField.MINUTE_OF_HOUR);
            int ss = TimeTZParser.access(dt, ChronoField.SECOND_OF_MINUTE);
            int micros = TimeTZParser.access(dt, ChronoField.NANO_OF_SECOND) / 1000;
            long microsFromMidnight = TimeTZParser.checkRange(format, (long)((hh * 60 + mm) * 60 + ss) * 1000000L + (long)micros, 86399999999L);
            int zoneSecondsFromUTC = 0;
            ZoneOffset zoneOffset = dt.query(TemporalQueries.offset());
            if (zoneOffset != null) {
                zoneSecondsFromUTC = zoneOffset.getTotalSeconds();
            } else {
                ZoneId zoneId = dt.query(TemporalQueries.zone());
                if (zoneId != null) {
                    zoneOffset = zoneId.getRules().getOffset(Instant.now());
                    zoneSecondsFromUTC = zoneOffset.getTotalSeconds();
                }
            }
            return new TimeTZ(microsFromMidnight, zoneSecondsFromUTC);
        }
        catch (DateTimeException e0) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "%s", e0.getMessage()));
        }
    }

    private static int access(TemporalAccessor time, ChronoField field) {
        return time.isSupported(field) ? time.get(field) : 0;
    }

    public static String formatTime(@Nonnull TimeTZ time) {
        String localTime = LocalTime.ofNanoOfDay(time.getMicrosFromMidnight() * 1000L).format(DateTimeFormatter.ISO_TIME);
        int secondsFromUTC = time.getSecondsFromUTC();
        if (secondsFromUTC != 0) {
            return String.format(Locale.ENGLISH, "%s%s", localTime, ZoneOffset.ofTotalSeconds(time.getSecondsFromUTC()));
        }
        return localTime;
    }

    static IllegalArgumentException exceptionForInvalidLiteral(Object literal) {
        throw new IllegalArgumentException(String.format(Locale.ENGLISH, "value [%s] is not a valid literal for %s", literal, TimeTZType.class.getSimpleName()));
    }

    private static long checkRange(String name, long value, long max) {
        if (value < 0L || value > max) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "value [%d] is out of range for '%s' [0, %d]", value, name, max));
        }
        return value;
    }
}

