/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.Streamer;
import io.crate.common.StringUtils;
import io.crate.common.unit.TimeValue;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.Regproc;
import io.crate.types.TypeSignature;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentFactory;

public class StringType
extends DataType<String>
implements Streamer<String> {
    public static final int ID = 4;
    public static final StringType INSTANCE = new StringType();
    public static final String T = "t";
    public static final String F = "f";
    private final int lengthLimit;

    public static StringType of(List<Integer> parameters) {
        if (parameters.size() != 1) {
            throw new IllegalArgumentException("The text type can only have a single parameter value, received: " + parameters.size());
        }
        return StringType.of(parameters.get(0));
    }

    public static StringType of(int lengthLimit) {
        if (lengthLimit <= 0) {
            throw new IllegalArgumentException("The text type length must be at least 1, received: " + lengthLimit);
        }
        return new StringType(lengthLimit);
    }

    private StringType(int lengthLimit) {
        this.lengthLimit = lengthLimit;
    }

    public StringType(StreamInput in) throws IOException {
        this.lengthLimit = in.getVersion().onOrAfter(Version.V_4_2_0) ? in.readInt() : Integer.MAX_VALUE;
    }

    protected StringType() {
        this(Integer.MAX_VALUE);
    }

    @Override
    public int id() {
        return 4;
    }

    @Override
    public DataType.Precedence precedence() {
        return DataType.Precedence.STRING;
    }

    @Override
    public String getName() {
        return "text";
    }

    public int lengthLimit() {
        return this.lengthLimit;
    }

    public boolean unbound() {
        return this.lengthLimit == Integer.MAX_VALUE;
    }

    @Override
    public TypeSignature getTypeSignature() {
        if (this.unbound()) {
            return super.getTypeSignature();
        }
        return new TypeSignature(this.getName(), List.of(TypeSignature.of(this.lengthLimit)));
    }

    @Override
    public List<DataType<?>> getTypeParameters() {
        if (this.unbound()) {
            return List.of();
        }
        return List.of(DataTypes.INTEGER);
    }

    @Override
    public Streamer<String> streamer() {
        return this;
    }

    @Override
    public String implicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof BytesRef) {
            return ((BytesRef)value).utf8ToString();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? T : F;
        }
        if (value instanceof Map) {
            try {
                return Strings.toString(XContentFactory.jsonBuilder().map((Map)value));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot cast `" + value + "` to type TEXT", e);
            }
        }
        if (value instanceof Collection) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot cast %s to type TEXT", value));
        }
        if (value.getClass().isArray()) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot cast %s to type TEXT", Arrays.toString((Object[])value)));
        }
        if (value instanceof TimeValue) {
            return ((TimeValue)value).getStringRep();
        }
        if (value instanceof Regproc) {
            return ((Regproc)value).name();
        }
        return value.toString();
    }

    @Override
    public String explicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        if (value == null) {
            return null;
        }
        String string = this.implicitCast(value);
        if (this.unbound() || string.length() <= this.lengthLimit) {
            return string;
        }
        return string.substring(0, this.lengthLimit);
    }

    @Override
    public String valueForInsert(Object value) {
        if (value == null) {
            return null;
        }
        assert (value instanceof String) : "valueForInsert must be called only on objects of String type";
        Object string = (String)value;
        if (this.unbound() || ((String)string).length() <= this.lengthLimit) {
            return string;
        }
        if (StringUtils.isBlank((String)string, this.lengthLimit, ((String)string).length())) {
            return ((String)string).substring(0, this.lengthLimit);
        }
        if (((String)string).length() > 20) {
            string = ((String)string).substring(0, 20) + "...";
        }
        throw new IllegalArgumentException("'" + (String)string + "' is too long for the text type of length: " + this.lengthLimit);
    }

    @Override
    public String sanitizeValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BytesRef) {
            return ((BytesRef)value).utf8ToString();
        }
        return (String)value;
    }

    @Override
    public boolean isConvertableTo(DataType<?> other, boolean explicitCast) {
        if (explicitCast) {
            if (other.id() == 100 && ((ArrayType)other).innerType().id() == this.id()) {
                return true;
            }
            if (other.id() == 17) {
                return true;
            }
        }
        return super.isConvertableTo(other, explicitCast);
    }

    @Override
    public int compare(String val1, String val2) {
        return val1.compareTo(val2);
    }

    @Override
    public String readValueFrom(StreamInput in) throws IOException {
        return in.readOptionalString();
    }

    @Override
    public void writeValueTo(StreamOutput out, String v) throws IOException {
        out.writeOptionalString(v);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_4_2_0)) {
            out.writeInt(this.lengthLimit);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StringType that = (StringType)o;
        return this.lengthLimit == that.lengthLimit;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.lengthLimit);
    }
}

