/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.Streamer;
import io.crate.types.DataType;
import io.crate.types.FixedWidthType;
import java.io.IOException;
import java.math.BigDecimal;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ShortType
extends DataType<Short>
implements Streamer<Short>,
FixedWidthType {
    public static final ShortType INSTANCE = new ShortType();
    public static final int ID = 8;
    private static final int SHORT_SIZE = (int)RamUsageEstimator.shallowSizeOfInstance(Short.class);

    private ShortType() {
    }

    @Override
    public int id() {
        return 8;
    }

    @Override
    public DataType.Precedence precedence() {
        return DataType.Precedence.SHORT;
    }

    @Override
    public String getName() {
        return "smallint";
    }

    @Override
    public Streamer<Short> streamer() {
        return this;
    }

    @Override
    public Short implicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        if (value == null) {
            return null;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof String) {
            return Short.valueOf((String)value);
        }
        if (value instanceof BigDecimal) {
            try {
                return ((BigDecimal)value).shortValueExact();
            }
            catch (ArithmeticException e) {
                throw new IllegalArgumentException("short value out of range: " + value);
            }
        }
        if (value instanceof Number) {
            int intVal = ((Number)value).intValue();
            if (intVal < Short.MIN_VALUE || Short.MAX_VALUE < intVal) {
                throw new IllegalArgumentException("short value out of range: " + intVal);
            }
            return ((Number)value).shortValue();
        }
        throw new ClassCastException("Can't cast '" + value + "' to " + this.getName());
    }

    @Override
    public Short sanitizeValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        return ((Number)value).shortValue();
    }

    @Override
    public int compare(Short val1, Short val2) {
        return Short.compare(val1, val2);
    }

    @Override
    public Short readValueFrom(StreamInput in) throws IOException {
        return in.readBoolean() ? null : Short.valueOf(in.readShort());
    }

    @Override
    public void writeValueTo(StreamOutput out, Short v) throws IOException {
        out.writeBoolean(v == null);
        if (v != null) {
            out.writeShort(v);
        }
    }

    @Override
    public int fixedSize() {
        return SHORT_SIZE;
    }
}

