/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.Streamer;
import io.crate.common.collections.MapComparator;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.ParameterTypeSignature;
import io.crate.types.StringType;
import io.crate.types.TypeSignature;
import io.crate.types.UndefinedType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;

public class ObjectType
extends DataType<Map<String, Object>>
implements Streamer<Map<String, Object>> {
    public static final ObjectType UNTYPED = new ObjectType();
    public static final int ID = 12;
    public static final String NAME = "object";
    private final Map<String, DataType<?>> innerTypes;

    public static Builder builder() {
        return new Builder();
    }

    private ObjectType() {
        this(Map.of());
    }

    private ObjectType(Map<String, DataType<?>> innerTypes) {
        this.innerTypes = innerTypes;
    }

    public Map<String, DataType<?>> innerTypes() {
        return this.innerTypes;
    }

    public DataType<?> innerType(String key) {
        return this.innerTypes.getOrDefault(key, UndefinedType.INSTANCE);
    }

    public DataType<?> resolveInnerType(List<String> path) {
        if (path.isEmpty()) {
            return DataTypes.UNDEFINED;
        }
        DataType innerType = DataTypes.UNDEFINED;
        ObjectType currentObject = this;
        for (int i = 0; i < path.size(); ++i) {
            innerType = currentObject.innerTypes().get(path.get(i));
            if (innerType == null) {
                return DataTypes.UNDEFINED;
            }
            if (innerType.id() != 12) continue;
            currentObject = (ObjectType)innerType;
        }
        return innerType;
    }

    @Override
    public int id() {
        return 12;
    }

    @Override
    public DataType.Precedence precedence() {
        return DataType.Precedence.OBJECT;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Streamer<Map<String, Object>> streamer() {
        return this;
    }

    @Override
    public Map<String, Object> implicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        return this.convert(value, DataType::implicitCast);
    }

    @Override
    public Map<String, Object> explicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        return this.convert(value, DataType::explicitCast);
    }

    @Override
    public Map<String, Object> sanitizeValue(Object value) {
        return this.convert(value, DataType::sanitizeValue);
    }

    private Map<String, Object> convert(Object value, BiFunction<DataType<?>, Object, Object> innerType) {
        Map map;
        if (value instanceof String) {
            value = ObjectType.mapFromJSONString((String)((Object)value));
        }
        if ((map = (Map)value) == null || this.innerTypes == null) {
            return map;
        }
        HashMap<String, Object> newMap = new HashMap<String, Object>(map);
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            newMap.put(key, innerType.apply(this.innerTypes.getOrDefault(key, UndefinedType.INSTANCE), entry.getValue()));
        }
        return newMap;
    }

    private static Map<String, Object> mapFromJSONString(String value) {
        try {
            XContentParser parser = JsonXContent.JSON_XCONTENT.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, value);
            return parser.map();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int compare(Map<String, Object> val1, Map<String, Object> val2) {
        return MapComparator.compareMaps(val1, val2);
    }

    @Override
    public Map<String, Object> readValueFrom(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            int size = in.readInt();
            HashMap<String, Object> m = new HashMap<String, Object>(size);
            for (int i = 0; i < size; ++i) {
                String key = in.readString();
                DataType innerType = this.innerTypes.getOrDefault(key, UndefinedType.INSTANCE);
                Object val = innerType.streamer().readValueFrom(in);
                m.put(key, val);
            }
            return m;
        }
        return null;
    }

    @Override
    public boolean isConvertableTo(DataType<?> o, boolean explicitCast) {
        Set conversions = DataTypes.ALLOWED_CONVERSIONS.getOrDefault(this.id(), Set.of());
        if (conversions.contains(o.id())) {
            return true;
        }
        if (explicitCast && o.id() == DataTypes.STRING.id()) {
            return true;
        }
        if (o.id() != this.id() || o.id() == DataTypes.UNDEFINED.id()) {
            return false;
        }
        ObjectType that = (ObjectType)o;
        if (this.innerTypes.isEmpty() || that.innerTypes().isEmpty()) {
            return true;
        }
        for (Map.Entry<String, DataType<?>> thisInnerField : this.innerTypes.entrySet()) {
            DataType<?> thisInnerType = thisInnerField.getValue();
            DataType<?> thatInnerType = that.innerTypes().get(thisInnerField.getKey());
            if (thatInnerType != null && thisInnerType.isConvertableTo(thatInnerType, explicitCast)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        ObjectType that = (ObjectType)o;
        return Objects.equals(this.innerTypes, that.innerTypes);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        return 31 * result + this.innerTypes.hashCode();
    }

    @Override
    public void writeValueTo(StreamOutput out, Map<String, Object> v) throws IOException {
        if (v == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeInt(v.size());
            for (Map.Entry<String, Object> entry : v.entrySet()) {
                String key = entry.getKey();
                out.writeString(key);
                DataType innerType = this.innerTypes.getOrDefault(key, UndefinedType.INSTANCE);
                innerType.streamer().writeValueTo(out, innerType.implicitCast(entry.getValue()));
            }
        }
    }

    public ObjectType(StreamInput in) throws IOException {
        int typesSize = in.readVInt();
        HashMap builder = new HashMap();
        for (int i = 0; i < typesSize; ++i) {
            String key = in.readString();
            DataType<?> type = DataTypes.fromStream(in);
            builder.put(key, type);
        }
        this.innerTypes = Collections.unmodifiableMap(builder);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.innerTypes.size());
        for (Map.Entry<String, DataType<?>> entry : this.innerTypes.entrySet()) {
            out.writeString(entry.getKey());
            DataTypes.toStream(entry.getValue(), out);
        }
    }

    @Override
    public TypeSignature getTypeSignature() {
        ArrayList<TypeSignature> parameters = new ArrayList<TypeSignature>(this.innerTypes.size() * 2);
        for (Map.Entry<String, DataType<?>> innerTypeKeyValue : this.innerTypes.entrySet()) {
            parameters.add(StringType.INSTANCE.getTypeSignature());
            DataType<?> innerType = innerTypeKeyValue.getValue();
            parameters.add(new ParameterTypeSignature(innerTypeKeyValue.getKey(), innerType.getTypeSignature()));
        }
        return new TypeSignature(NAME, parameters);
    }

    @Override
    public List<DataType<?>> getTypeParameters() {
        ArrayList parameters = new ArrayList(this.innerTypes.size() * 2);
        for (DataType<?> type : this.innerTypes.values()) {
            parameters.add(StringType.INSTANCE);
            parameters.add(type);
        }
        return parameters;
    }

    public static class Builder {
        Map<String, DataType<?>> innerTypesBuilder = new HashMap();

        public Builder setInnerType(String key, DataType<?> innerType) {
            this.innerTypesBuilder.put(key, innerType);
            return this;
        }

        public ObjectType build() {
            return new ObjectType(Collections.unmodifiableMap(this.innerTypesBuilder));
        }
    }
}

