/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.Streamer;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class NumericType
extends DataType<BigDecimal>
implements Streamer<BigDecimal> {
    public static final int ID = 22;
    public static final NumericType INSTANCE = new NumericType(null, null);
    @Nullable
    private final Integer scale;
    @Nullable
    private final Integer precision;

    public static NumericType of(int precision) {
        return new NumericType(precision, 0);
    }

    public static NumericType of(int precision, int scale) {
        return new NumericType(precision, scale);
    }

    public static DataType<?> of(List<Integer> parameters) {
        if (parameters.isEmpty() || parameters.size() > 2) {
            throw new IllegalArgumentException("The numeric type support one or two parameter arguments, received: " + parameters.size());
        }
        if (parameters.size() == 1) {
            return NumericType.of(parameters.get(0));
        }
        return NumericType.of(parameters.get(0), parameters.get(1));
    }

    private NumericType(@Nullable Integer precision, @Nullable Integer scale) {
        this.precision = precision;
        this.scale = scale;
    }

    public NumericType(StreamInput in) throws IOException {
        this.precision = in.readOptionalVInt();
        this.scale = in.readOptionalVInt();
    }

    @Override
    public int id() {
        return 22;
    }

    @Override
    public DataType.Precedence precedence() {
        return DataType.Precedence.NUMERIC;
    }

    @Override
    public String getName() {
        return "numeric";
    }

    @Override
    public Streamer<BigDecimal> streamer() {
        return this;
    }

    @Override
    public BigDecimal implicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        BigDecimal bd;
        if (value == null) {
            return null;
        }
        MathContext mathContext = this.mathContextOrDefault();
        if (value instanceof Long || value instanceof Byte || value instanceof Integer || value instanceof Short) {
            bd = new BigDecimal(BigInteger.valueOf(((Number)value).longValue()), mathContext);
        } else if (value instanceof String || value instanceof Float || value instanceof Double || value instanceof BigDecimal) {
            bd = new BigDecimal(value.toString(), mathContext);
        } else {
            throw new ClassCastException("Can't cast '" + value + "' to " + this.getName());
        }
        if (this.scale != null) {
            bd = bd.setScale((int)this.scale, mathContext.getRoundingMode());
        }
        return bd;
    }

    @Override
    public BigDecimal sanitizeValue(Object value) {
        if (value == null) {
            return null;
        }
        return (BigDecimal)value;
    }

    @Override
    public BigDecimal valueForInsert(Object value) {
        throw new UnsupportedOperationException(this.getName() + " type cannot be used in insert statements");
    }

    public static long size(@Nonnull BigDecimal value) {
        return 36 + value.unscaledValue().bitLength() / 8 + 1;
    }

    public static long sizeDiff(@Nonnull BigDecimal first, @Nonnull BigDecimal second) {
        return NumericType.size(first) - NumericType.size(second);
    }

    @Nullable
    @VisibleForTesting
    Integer scale() {
        return this.scale;
    }

    @Nullable
    @VisibleForTesting
    Integer precision() {
        return this.precision;
    }

    private MathContext mathContextOrDefault() {
        if (this.precision == null) {
            return MathContext.UNLIMITED;
        }
        return new MathContext(this.precision);
    }

    private boolean unscaled() {
        return this.precision == null;
    }

    @Override
    public TypeSignature getTypeSignature() {
        if (this.unscaled()) {
            return super.getTypeSignature();
        }
        ArrayList<TypeSignature> parameters = new ArrayList<TypeSignature>();
        parameters.add(TypeSignature.of(this.precision));
        if (this.scale != null) {
            parameters.add(TypeSignature.of(this.scale));
        }
        return new TypeSignature(this.getName(), parameters);
    }

    @Override
    public List<DataType<?>> getTypeParameters() {
        if (this.unscaled()) {
            return List.of();
        }
        if (this.scale != null) {
            return List.of(DataTypes.INTEGER);
        }
        return List.of(DataTypes.INTEGER, DataTypes.INTEGER);
    }

    @Override
    public int compare(BigDecimal o1, BigDecimal o2) {
        return o1.compareTo(o2);
    }

    @Override
    public BigDecimal readValueFrom(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            byte[] bytes = in.readByteArray();
            return new BigDecimal(new BigInteger(bytes), this.scale == null ? 0 : this.scale, this.mathContextOrDefault());
        }
        return null;
    }

    @Override
    public void writeValueTo(StreamOutput out, BigDecimal v) throws IOException {
        if (v != null) {
            out.writeBoolean(true);
            out.writeByteArray(v.unscaledValue().toByteArray());
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalVInt(this.precision);
        out.writeOptionalVInt(this.scale);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NumericType that = (NumericType)o;
        return Objects.equals(this.scale, that.scale) && Objects.equals(this.precision, that.precision);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.scale, this.precision);
    }
}

