/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.Streamer;
import io.crate.types.DataType;
import io.crate.types.FixedWidthType;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class LongType
extends DataType<Long>
implements FixedWidthType,
Streamer<Long> {
    public static final LongType INSTANCE = new LongType();
    public static final int ID = 10;
    public static final int LONG_SIZE = (int)RamUsageEstimator.shallowSizeOfInstance(Long.class);

    @Override
    public int id() {
        return 10;
    }

    @Override
    public DataType.Precedence precedence() {
        return DataType.Precedence.LONG;
    }

    @Override
    public String getName() {
        return "bigint";
    }

    @Override
    public Streamer<Long> streamer() {
        return this;
    }

    @Override
    public Long implicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            return Long.valueOf((String)value);
        }
        if (value instanceof BigDecimal) {
            BigDecimal bigDecimalValue = (BigDecimal)value;
            BigInteger max = BigDecimal.valueOf(Long.MAX_VALUE).toBigInteger();
            BigInteger min = BigDecimal.valueOf(Long.MIN_VALUE).toBigInteger();
            if (max.compareTo(bigDecimalValue.toBigInteger()) <= 0 || min.compareTo(bigDecimalValue.toBigInteger()) >= 0) {
                throw new IllegalArgumentException(this.getName() + " value out of range: " + value);
            }
            return ((BigDecimal)value).longValue();
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        throw new ClassCastException("Can't cast '" + value + "' to " + this.getName());
    }

    @Override
    public Long sanitizeValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        return ((Number)value).longValue();
    }

    @Override
    public int compare(Long val1, Long val2) {
        return Long.compare(val1, val2);
    }

    @Override
    public Long readValueFrom(StreamInput in) throws IOException {
        return in.readBoolean() ? null : Long.valueOf(in.readLong());
    }

    @Override
    public void writeValueTo(StreamOutput out, Long v) throws IOException {
        out.writeBoolean(v == null);
        if (v != null) {
            out.writeLong(v);
        }
    }

    @Override
    public int fixedSize() {
        return LONG_SIZE;
    }
}

