/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.Streamer;
import io.crate.types.DataType;
import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.network.InetAddresses;

public class IpType
extends DataType<String>
implements Streamer<String> {
    public static final int ID = 5;
    public static final IpType INSTANCE = new IpType();

    @Override
    public int id() {
        return 5;
    }

    @Override
    public String getName() {
        return "ip";
    }

    @Override
    public Streamer<String> streamer() {
        return this;
    }

    @Override
    public String implicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            this.validate((String)value);
            return (String)value;
        }
        if (value instanceof Number) {
            long longIp = ((Number)value).longValue();
            if (longIp < 0L) {
                throw new IllegalArgumentException("Failed to convert long value: " + longIp + " to ipv4 address");
            }
            return IpType.longToIp(longIp);
        }
        throw new ClassCastException("Can't cast '" + value + "' to " + this.getName());
    }

    @Override
    public DataType.Precedence precedence() {
        return DataType.Precedence.IP;
    }

    @Override
    public String sanitizeValue(Object value) {
        if (value == null) {
            return null;
        }
        this.validate((String)value);
        return (String)value;
    }

    private static String longToIp(long longIp) {
        int octet3 = (int)((longIp >> 24) % 256L);
        int octet2 = (int)((longIp >> 16) % 256L);
        int octet1 = (int)((longIp >> 8) % 256L);
        int octet0 = (int)(longIp % 256L);
        return octet3 + "." + octet2 + "." + octet1 + "." + octet0;
    }

    private void validate(String ip) {
        if (!InetAddresses.isInetAddress(ip)) {
            throw new IllegalArgumentException("Failed to validate ip [" + ip + "], not a valid ipv4 address");
        }
    }

    @Override
    public int compare(String val1, String val2) {
        return val1.compareTo(val2);
    }

    @Override
    public String readValueFrom(StreamInput in) throws IOException {
        return in.readOptionalString();
    }

    @Override
    public void writeValueTo(StreamOutput out, String v) throws IOException {
        out.writeOptionalString(v);
    }
}

