/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.Streamer;
import io.crate.interval.IntervalParser;
import io.crate.types.DataType;
import io.crate.types.FixedWidthType;
import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public class IntervalType
extends DataType<Period>
implements FixedWidthType,
Streamer<Period> {
    public static final int ID = 17;
    public static final IntervalType INSTANCE = new IntervalType();
    public static final PeriodFormatter PERIOD_FORMATTER = new PeriodFormatterBuilder().appendYears().appendSuffix(" year", " years").appendSeparator(" ").appendMonths().appendSuffix(" mon", " mons").appendSeparator(" ").appendWeeks().appendSuffix(" weeks").appendSeparator(" ").appendDays().printZeroAlways().minimumPrintedDigits(2).appendSuffix(" day", " days").appendSeparator(" ").appendHours().minimumPrintedDigits(2).printZeroAlways().appendSeparator(":").appendMinutes().minimumPrintedDigits(2).printZeroAlways().appendSeparator(":").appendSecondsWithOptionalMillis().toFormatter();

    @Override
    public int id() {
        return 17;
    }

    @Override
    public DataType.Precedence precedence() {
        return DataType.Precedence.INTERVAL;
    }

    @Override
    public String getName() {
        return "interval";
    }

    @Override
    public Streamer<Period> streamer() {
        return this;
    }

    @Override
    public Period implicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return IntervalParser.apply((String)value);
        }
        throw new ClassCastException("Can't cast '" + value + "' to " + this.getName());
    }

    @Override
    public Period sanitizeValue(Object value) {
        if (value == null) {
            return null;
        }
        return (Period)value;
    }

    @Override
    public int compare(Period p1, Period p2) {
        return p1.toStandardDuration().compareTo((ReadableDuration)p2.toStandardDuration());
    }

    @Override
    public Period readValueFrom(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            return new Period(in.readVInt(), in.readVInt(), in.readVInt(), in.readVInt(), in.readVInt(), in.readVInt(), in.readVInt(), in.readVInt());
        }
        return null;
    }

    @Override
    public void writeValueTo(StreamOutput out, Period p) throws IOException {
        if (p == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeVInt(p.getYears());
            out.writeVInt(p.getMonths());
            out.writeVInt(p.getWeeks());
            out.writeVInt(p.getDays());
            out.writeVInt(p.getHours());
            out.writeVInt(p.getMinutes());
            out.writeVInt(p.getSeconds());
            out.writeVInt(p.getMillis());
        }
    }

    @Override
    public int fixedSize() {
        return 32;
    }
}

