/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.Streamer;
import io.crate.types.DataType;
import io.crate.types.FixedWidthType;
import io.crate.types.Regproc;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class IntegerType
extends DataType<Integer>
implements Streamer<Integer>,
FixedWidthType {
    public static final IntegerType INSTANCE = new IntegerType();
    public static final int ID = 9;
    private static final int INTEGER_SIZE = (int)RamUsageEstimator.shallowSizeOfInstance(Integer.class);

    private IntegerType() {
    }

    @Override
    public int id() {
        return 9;
    }

    @Override
    public DataType.Precedence precedence() {
        return DataType.Precedence.INTEGER;
    }

    @Override
    public String getName() {
        return "integer";
    }

    @Override
    public Streamer<Integer> streamer() {
        return this;
    }

    @Override
    public Integer implicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        if (value instanceof Regproc) {
            return ((Regproc)value).oid();
        }
        if (value instanceof BigDecimal) {
            BigDecimal bigDecimalValue = (BigDecimal)value;
            BigInteger max = BigDecimal.valueOf(Integer.MAX_VALUE).toBigInteger();
            BigInteger min = BigDecimal.valueOf(Integer.MIN_VALUE).toBigInteger();
            if (max.compareTo(bigDecimalValue.toBigInteger()) <= 0 || min.compareTo(bigDecimalValue.toBigInteger()) >= 0) {
                throw new IllegalArgumentException(this.getName() + " value out of range: " + value);
            }
            return ((BigDecimal)value).intValue();
        }
        if (value instanceof Number) {
            long longVal = ((Number)value).longValue();
            if (longVal < Integer.MIN_VALUE || Integer.MAX_VALUE < longVal) {
                throw new IllegalArgumentException("integer value out of range: " + longVal);
            }
            return ((Number)value).intValue();
        }
        throw new ClassCastException("Can't cast '" + value + "' to " + this.getName());
    }

    @Override
    public Integer sanitizeValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return ((Number)value).intValue();
    }

    @Override
    public int compare(Integer val1, Integer val2) {
        return Integer.compare(val1, val2);
    }

    @Override
    public Integer readValueFrom(StreamInput in) throws IOException {
        return in.readBoolean() ? null : Integer.valueOf(in.readInt());
    }

    @Override
    public void writeValueTo(StreamOutput out, Integer v) throws IOException {
        out.writeBoolean(v == null);
        if (v != null) {
            out.writeInt(v);
        }
    }

    @Override
    public int fixedSize() {
        return INTEGER_SIZE;
    }
}

