/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.types.TypeSignature;
import io.crate.types.TypeSignatureType;
import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

final class IntegerLiteralTypeSignature
extends TypeSignature {
    private final int value;

    public IntegerLiteralTypeSignature(int value) {
        super("");
        this.value = value;
    }

    public IntegerLiteralTypeSignature(StreamInput in) throws IOException {
        super(in);
        this.value = in.readInt();
    }

    public int value() {
        return this.value;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeInt(this.value);
    }

    @Override
    public TypeSignatureType type() {
        return TypeSignatureType.INTEGER_LITERAL_SIGNATURE;
    }

    @Override
    public String toString() {
        return String.valueOf(this.value);
    }
}

