/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.Streamer;
import io.crate.geo.GeoJSONUtils;
import io.crate.types.DataType;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.BytesRefs;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Shape;

public class GeoShapeType
extends DataType<Map<String, Object>>
implements Streamer<Map<String, Object>> {
    public static final int ID = 14;
    public static final GeoShapeType INSTANCE = new GeoShapeType();

    private GeoShapeType() {
    }

    @Override
    public int id() {
        return 14;
    }

    @Override
    public DataType.Precedence precedence() {
        return DataType.Precedence.GEO_SHAPE;
    }

    @Override
    public String getName() {
        return "geo_shape";
    }

    @Override
    public Streamer<Map<String, Object>> streamer() {
        return this;
    }

    @Override
    public Map<String, Object> implicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return GeoJSONUtils.wkt2Map(BytesRefs.toString(value));
        }
        if (value instanceof Point) {
            Point point = (Point)value;
            return GeoJSONUtils.shape2Map((Shape)SpatialContext.GEO.getShapeFactory().pointXY(point.getX(), point.getY()));
        }
        if (value instanceof Shape) {
            return GeoJSONUtils.shape2Map((Shape)value);
        }
        if (value instanceof Map) {
            GeoJSONUtils.validateGeoJson((Map)value);
            return (Map)value;
        }
        throw new ClassCastException("Can't cast '" + value + "' to " + this.getName());
    }

    @Override
    public Map<String, Object> sanitizeValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            GeoJSONUtils.validateGeoJson((Map)value);
            return (Map)value;
        }
        return GeoJSONUtils.shape2Map((Shape)value);
    }

    private String invalidMsg(Object value) {
        return String.format(Locale.ENGLISH, "Cannot convert \"%s\" to geo_shape", value);
    }

    @Override
    public int compare(Map<String, Object> val1, Map<String, Object> val2) {
        Shape shape1 = GeoJSONUtils.map2Shape(val1);
        Shape shape2 = GeoJSONUtils.map2Shape(val2);
        switch (shape1.relate(shape2)) {
            case WITHIN: {
                return -1;
            }
            case CONTAINS: {
                return 1;
            }
        }
        return Double.compare(shape1.getArea((SpatialContext)JtsSpatialContext.GEO), shape2.getArea((SpatialContext)JtsSpatialContext.GEO));
    }

    @Override
    public Map<String, Object> readValueFrom(StreamInput in) throws IOException {
        return in.readMap();
    }

    @Override
    public void writeValueTo(StreamOutput out, Map<String, Object> v) throws IOException {
        out.writeMap(v);
    }
}

