/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.Streamer;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.FixedWidthType;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.exception.InvalidShapeException;
import org.locationtech.spatial4j.io.WKTReader;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.impl.PointImpl;

public class GeoPointType
extends DataType<Point>
implements Streamer<Point>,
FixedWidthType {
    public static final int ID = 13;
    public static final GeoPointType INSTANCE = new GeoPointType();
    public static final WKTReader WKT_READER = (WKTReader)JtsSpatialContext.GEO.getFormats().getWktReader();

    private GeoPointType() {
    }

    @Override
    public int id() {
        return 13;
    }

    @Override
    public DataType.Precedence precedence() {
        return DataType.Precedence.GEO_POINT;
    }

    @Override
    public String getName() {
        return "geo_point";
    }

    @Override
    public Streamer<Point> streamer() {
        return this;
    }

    @Override
    public Point implicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        if (value == null) {
            return null;
        }
        if (value instanceof Point) {
            return (Point)value;
        }
        if (value instanceof Double[]) {
            Double[] doubles = (Double[])value;
            GeoPointType.checkLengthIs2(doubles.length);
            this.ensurePointsInRange(doubles[0], doubles[1]);
            return new PointImpl(doubles[0].doubleValue(), doubles[1].doubleValue(), (SpatialContext)JtsSpatialContext.GEO);
        }
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            GeoPointType.checkLengthIs2(values.length);
            PointImpl point = new PointImpl(((Number)values[0]).doubleValue(), ((Number)values[1]).doubleValue(), (SpatialContext)JtsSpatialContext.GEO);
            this.ensurePointsInRange(point.getX(), point.getY());
            return point;
        }
        if (value instanceof String) {
            return GeoPointType.pointFromString((String)value);
        }
        if (value instanceof List) {
            List values = (List)value;
            GeoPointType.checkLengthIs2(values.size());
            PointImpl point = new PointImpl(((Number)values.get(0)).doubleValue(), ((Number)values.get(1)).doubleValue(), (SpatialContext)JtsSpatialContext.GEO);
            this.ensurePointsInRange(point.getX(), point.getY());
            return point;
        }
        throw new ClassCastException("Can't cast '" + value + "' to " + this.getName());
    }

    @Override
    public Point sanitizeValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            List values = (List)value;
            GeoPointType.checkLengthIs2(values.size());
            PointImpl point = new PointImpl(((Number)values.get(0)).doubleValue(), ((Number)values.get(1)).doubleValue(), (SpatialContext)JtsSpatialContext.GEO);
            this.ensurePointsInRange(point.getX(), point.getY());
            return point;
        }
        return (Point)value;
    }

    private void ensurePointsInRange(double x, double y) {
        if (!GeoPointType.arePointsInRange(x, y)) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Failed to validate geo point [lon=%f, lat=%f], not a valid location.", x, y));
        }
    }

    private static boolean arePointsInRange(double x, double y) {
        return x >= -180.0 && x <= 180.0 && y >= -90.0 && y <= 90.0;
    }

    private static void checkLengthIs2(int actualLength) {
        if (actualLength != 2) {
            throw new IllegalArgumentException("The value of a GeoPoint must be a double array with 2 items, not " + actualLength);
        }
    }

    private static Point pointFromString(String value) {
        try {
            return (Point)WKT_READER.parse(value);
        }
        catch (ParseException | InvalidShapeException e) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot convert \"%s\" to geo_point. %s", value, e.getLocalizedMessage()), e);
        }
    }

    @Override
    public int compare(Point val1, Point val2) {
        if (val1 == null) {
            return -1;
        }
        if (val2 == null) {
            return 1;
        }
        int latComp = Double.compare(val1.getX(), val2.getX());
        if (latComp != 0) {
            return latComp;
        }
        return Double.compare(val1.getY(), val2.getY());
    }

    @Override
    public Point readValueFrom(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            return new PointImpl(in.readDouble(), in.readDouble(), (SpatialContext)JtsSpatialContext.GEO);
        }
        return null;
    }

    @Override
    public void writeValueTo(StreamOutput out, Point point) throws IOException {
        if (point == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeDouble(point.getX());
            out.writeDouble(point.getY());
        }
    }

    @Override
    public int fixedSize() {
        return 40;
    }

    @Override
    public boolean isConvertableTo(DataType<?> other, boolean explicitCast) {
        if (other.id() == this.id() || other instanceof ArrayType && ((ArrayType)other).innerType().equals(DataTypes.DOUBLE)) {
            return true;
        }
        return super.isConvertableTo(other, explicitCast);
    }
}

